/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.util.Preconditions;

public class FlightDescriptor {
    private boolean isCmd;
    private List<String> path;
    private byte[] cmd;

    private FlightDescriptor(boolean isCmd, List<String> path, byte[] cmd) {
        this.isCmd = isCmd;
        this.path = path;
        this.cmd = cmd;
    }

    public static FlightDescriptor command(byte[] cmd) {
        return new FlightDescriptor(true, null, cmd);
    }

    public static FlightDescriptor path(Iterable<String> path) {
        return new FlightDescriptor(false, (List<String>)ImmutableList.copyOf(path), null);
    }

    public static FlightDescriptor path(String ... path) {
        return new FlightDescriptor(false, (List<String>)ImmutableList.copyOf((Object[])path), null);
    }

    FlightDescriptor(Flight.FlightDescriptor descriptor) {
        if (descriptor.getType() == Flight.FlightDescriptor.DescriptorType.CMD) {
            this.isCmd = true;
            this.cmd = descriptor.getCmd().toByteArray();
        } else if (descriptor.getType() == Flight.FlightDescriptor.DescriptorType.PATH) {
            this.isCmd = false;
            this.path = descriptor.getPathList();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public boolean isCommand() {
        return this.isCmd;
    }

    public List<String> getPath() {
        Preconditions.checkArgument((!this.isCmd ? 1 : 0) != 0);
        return this.path;
    }

    public byte[] getCommand() {
        Preconditions.checkArgument((boolean)this.isCmd);
        return this.cmd;
    }

    Flight.FlightDescriptor toProtocol() {
        Flight.FlightDescriptor.Builder b = Flight.FlightDescriptor.newBuilder();
        if (this.isCmd) {
            return b.setType(Flight.FlightDescriptor.DescriptorType.CMD).setCmd(ByteString.copyFrom((byte[])this.cmd)).build();
        }
        return b.setType(Flight.FlightDescriptor.DescriptorType.PATH).addAllPath(this.path).build();
    }

    public ByteBuffer serialize() {
        return ByteBuffer.wrap(this.toProtocol().toByteArray());
    }

    public static FlightDescriptor deserialize(ByteBuffer serialized) throws IOException {
        return new FlightDescriptor(Flight.FlightDescriptor.parseFrom(serialized));
    }

    public String toString() {
        if (this.isCmd) {
            return this.toHex(this.cmd);
        }
        return Joiner.on((char)'.').join(this.path);
    }

    private String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X ", b));
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cmd == null ? 0 : Arrays.hashCode(this.cmd));
        result = 31 * result + (this.isCmd ? 1231 : 1237);
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlightDescriptor other = (FlightDescriptor)obj;
        if (this.cmd == null ? other.cmd != null : !Arrays.equals(this.cmd, other.cmd)) {
            return false;
        }
        if (this.isCmd != other.isCmd) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

