/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.arrow.flight.CallHeaders;

public class FlightCallHeaders
implements CallHeaders {
    private final Multimap<String, Object> keysAndValues = ArrayListMultimap.create();

    @Override
    public String get(String key) {
        Collection values = this.keysAndValues.get((Object)key);
        if (values.isEmpty()) {
            return null;
        }
        if (key.endsWith("-bin")) {
            return new String((byte[])Iterables.get((Iterable)values, (int)0));
        }
        return (String)Iterables.get((Iterable)values, (int)0);
    }

    @Override
    public byte[] getByte(String key) {
        Collection values = this.keysAndValues.get((Object)key);
        if (values.isEmpty()) {
            return null;
        }
        if (key.endsWith("-bin")) {
            return (byte[])Iterables.get((Iterable)values, (int)0);
        }
        return ((String)Iterables.get((Iterable)values, (int)0)).getBytes();
    }

    @Override
    public Iterable<String> getAll(String key) {
        if (key.endsWith("-bin")) {
            return this.keysAndValues.get((Object)key).stream().map(o -> new String((byte[])o)).collect(Collectors.toList());
        }
        return this.keysAndValues.get((Object)key);
    }

    @Override
    public Iterable<byte[]> getAllByte(String key) {
        if (key.endsWith("-bin")) {
            return this.keysAndValues.get((Object)key);
        }
        return this.keysAndValues.get((Object)key).stream().map(o -> ((String)o).getBytes()).collect(Collectors.toList());
    }

    @Override
    public void insert(String key, String value) {
        this.keysAndValues.put((Object)key, (Object)value);
    }

    @Override
    public void insert(String key, byte[] value) {
        Preconditions.checkArgument((boolean)key.endsWith("-bin"), (String)"Binary header is named %s. It must end with %s", (Object)key, (Object)"-bin");
        Preconditions.checkArgument((key.length() > "-bin".length() ? 1 : 0) != 0, (Object)"empty key name");
        this.keysAndValues.put((Object)key, (Object)value);
    }

    @Override
    public Set<String> keys() {
        return this.keysAndValues.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.keysAndValues.containsKey((Object)key);
    }

    public String toString() {
        return this.keysAndValues.toString();
    }
}

