/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightService;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.flight.impl.FlightServiceGrpc;
import org.apache.arrow.memory.BufferAllocator;

class FlightBindingService
implements BindableService {
    private static final String DO_GET = MethodDescriptor.generateFullMethodName((String)"arrow.flight.protocol.FlightService", (String)"DoGet");
    private static final String DO_PUT = MethodDescriptor.generateFullMethodName((String)"arrow.flight.protocol.FlightService", (String)"DoPut");
    private static final String DO_EXCHANGE = MethodDescriptor.generateFullMethodName((String)"arrow.flight.protocol.FlightService", (String)"DoExchange");
    private static final Set<String> OVERRIDE_METHODS = ImmutableSet.of((Object)DO_GET, (Object)DO_PUT, (Object)DO_EXCHANGE);
    private final FlightService delegate;
    private final BufferAllocator allocator;

    public FlightBindingService(BufferAllocator allocator, FlightProducer producer, ServerAuthHandler authHandler, ExecutorService executor) {
        this.allocator = allocator;
        this.delegate = new FlightService(allocator, producer, authHandler, executor);
    }

    public static MethodDescriptor<Flight.Ticket, ArrowMessage> getDoGetDescriptor(BufferAllocator allocator) {
        return MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName(DO_GET).setSampledToLocalTracing(false).setRequestMarshaller(ProtoUtils.marshaller((Message)Flight.Ticket.getDefaultInstance())).setResponseMarshaller(ArrowMessage.createMarshaller(allocator)).setSchemaDescriptor(FlightServiceGrpc.getDoGetMethod().getSchemaDescriptor()).build();
    }

    public static MethodDescriptor<ArrowMessage, Flight.PutResult> getDoPutDescriptor(BufferAllocator allocator) {
        return MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(DO_PUT).setSampledToLocalTracing(false).setRequestMarshaller(ArrowMessage.createMarshaller(allocator)).setResponseMarshaller(ProtoUtils.marshaller((Message)Flight.PutResult.getDefaultInstance())).setSchemaDescriptor(FlightServiceGrpc.getDoPutMethod().getSchemaDescriptor()).build();
    }

    public static MethodDescriptor<ArrowMessage, ArrowMessage> getDoExchangeDescriptor(BufferAllocator allocator) {
        return MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(DO_EXCHANGE).setSampledToLocalTracing(false).setRequestMarshaller(ArrowMessage.createMarshaller(allocator)).setResponseMarshaller(ArrowMessage.createMarshaller(allocator)).setSchemaDescriptor(FlightServiceGrpc.getDoExchangeMethod().getSchemaDescriptor()).build();
    }

    public ServerServiceDefinition bindService() {
        ServerServiceDefinition baseDefinition = this.delegate.bindService();
        MethodDescriptor<Flight.Ticket, ArrowMessage> doGetDescriptor = FlightBindingService.getDoGetDescriptor(this.allocator);
        MethodDescriptor<ArrowMessage, Flight.PutResult> doPutDescriptor = FlightBindingService.getDoPutDescriptor(this.allocator);
        MethodDescriptor<ArrowMessage, ArrowMessage> doExchangeDescriptor = FlightBindingService.getDoExchangeDescriptor(this.allocator);
        ServiceDescriptor.Builder serviceDescriptorBuilder = ServiceDescriptor.newBuilder((String)"arrow.flight.protocol.FlightService").setSchemaDescriptor(baseDefinition.getServiceDescriptor().getSchemaDescriptor());
        serviceDescriptorBuilder.addMethod(doGetDescriptor);
        serviceDescriptorBuilder.addMethod(doPutDescriptor);
        serviceDescriptorBuilder.addMethod(doExchangeDescriptor);
        for (MethodDescriptor definition : baseDefinition.getServiceDescriptor().getMethods()) {
            if (OVERRIDE_METHODS.contains(definition.getFullMethodName())) continue;
            serviceDescriptorBuilder.addMethod(definition);
        }
        ServiceDescriptor serviceDescriptor = serviceDescriptorBuilder.build();
        ServerServiceDefinition.Builder serviceBuilder = ServerServiceDefinition.builder((ServiceDescriptor)serviceDescriptor);
        serviceBuilder.addMethod(doGetDescriptor, ServerCalls.asyncServerStreamingCall((ServerCalls.ServerStreamingMethod)new DoGetMethod(this.delegate)));
        serviceBuilder.addMethod(doPutDescriptor, ServerCalls.asyncBidiStreamingCall((ServerCalls.BidiStreamingMethod)new DoPutMethod(this.delegate)));
        serviceBuilder.addMethod(doExchangeDescriptor, ServerCalls.asyncBidiStreamingCall((ServerCalls.BidiStreamingMethod)new DoExchangeMethod(this.delegate)));
        for (ServerMethodDefinition definition : baseDefinition.getMethods()) {
            if (OVERRIDE_METHODS.contains(definition.getMethodDescriptor().getFullMethodName())) continue;
            serviceBuilder.addMethod(definition);
        }
        return serviceBuilder.build();
    }

    private static class DoExchangeMethod
    implements ServerCalls.BidiStreamingMethod<ArrowMessage, ArrowMessage> {
        private final FlightService delegate;

        public DoExchangeMethod(FlightService delegate) {
            this.delegate = delegate;
        }

        public StreamObserver<ArrowMessage> invoke(StreamObserver<ArrowMessage> responseObserver) {
            return this.delegate.doExchangeCustom(responseObserver);
        }
    }

    private static class DoPutMethod
    implements ServerCalls.BidiStreamingMethod<ArrowMessage, Flight.PutResult> {
        private final FlightService delegate;

        public DoPutMethod(FlightService delegate) {
            this.delegate = delegate;
        }

        public StreamObserver<ArrowMessage> invoke(StreamObserver<Flight.PutResult> responseObserver) {
            return this.delegate.doPutCustom(responseObserver);
        }
    }

    private static class DoGetMethod
    implements ServerCalls.ServerStreamingMethod<Flight.Ticket, ArrowMessage> {
        private final FlightService delegate;

        public DoGetMethod(FlightService delegate) {
            this.delegate = delegate;
        }

        public void invoke(Flight.Ticket request, StreamObserver<ArrowMessage> responseObserver) {
            this.delegate.doGetCustom(request, responseObserver);
        }
    }
}

