/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.flight.FlightBindingService;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.VisibleForTesting;

public class FlightGrpcUtils {
    private FlightGrpcUtils() {
    }

    public static BindableService createFlightService(BufferAllocator allocator, FlightProducer producer, ServerAuthHandler authHandler, ExecutorService executor) {
        return new FlightBindingService(allocator, producer, authHandler, executor);
    }

    public static FlightClient createFlightClient(BufferAllocator incomingAllocator, ManagedChannel channel) {
        return new FlightClient(incomingAllocator, channel, Collections.emptyList());
    }

    public static FlightClient createFlightClientWithSharedChannel(BufferAllocator incomingAllocator, ManagedChannel channel) {
        return new FlightClient(incomingAllocator, (ManagedChannel)new NonClosingProxyManagedChannel(channel), Collections.emptyList());
    }

    @VisibleForTesting
    static class NonClosingProxyManagedChannel
    extends ManagedChannel {
        private final ManagedChannel channel;
        private boolean isShutdown;

        NonClosingProxyManagedChannel(ManagedChannel channel) {
            this.channel = channel;
            this.isShutdown = channel.isShutdown();
        }

        public ManagedChannel shutdown() {
            this.isShutdown = true;
            return this;
        }

        public boolean isShutdown() {
            if (this.channel.isShutdown()) {
                this.shutdown();
            }
            return this.isShutdown;
        }

        public boolean isTerminated() {
            return this.isShutdown();
        }

        public ManagedChannel shutdownNow() {
            return this.shutdown();
        }

        public boolean awaitTermination(long l, TimeUnit timeUnit) {
            return this.isShutdown();
        }

        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            if (this.isShutdown()) {
                throw new IllegalStateException("Channel has been shut down.");
            }
            return this.channel.newCall(methodDescriptor, callOptions);
        }

        public String authority() {
            return this.channel.authority();
        }

        public ConnectivityState getState(boolean requestConnection) {
            if (this.isShutdown()) {
                return ConnectivityState.SHUTDOWN;
            }
            return this.channel.getState(requestConnection);
        }

        public void notifyWhenStateChanged(ConnectivityState source, Runnable callback) {
            this.channel.notifyWhenStateChanged(source, callback);
        }

        public void resetConnectBackoff() {
            this.channel.resetConnectBackoff();
        }

        public void enterIdle() {
            this.channel.enterIdle();
        }
    }
}

