/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

public class StringBuilderHelper {
    private static final int MAX_BUF_SIZE = 8192;
    private static final ThreadLocal<StringBuilderHolder> HOLDER_THREAD_LOCAL = ThreadLocal.withInitial(() -> new StringBuilderHolder());

    public static StringBuilder get() {
        StringBuilderHolder holder = HOLDER_THREAD_LOCAL.get();
        return holder.getStringBuilder();
    }

    public static void truncate() {
        StringBuilderHolder holder = HOLDER_THREAD_LOCAL.get();
        holder.truncate();
    }

    private static class StringBuilderHolder {
        private StringBuilder buf = new StringBuilder();

        private StringBuilderHolder() {
        }

        private StringBuilder getStringBuilder() {
            this.truncate();
            return this.buf;
        }

        private void truncate() {
            if (this.buf.capacity() < MAX_BUF_SIZE) {
                this.buf.setLength(0);
            } else {
                this.buf = new StringBuilder();
            }
        }
    }
}

