/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.signal;

import io.greptime.common.signal.Signal;
import io.greptime.common.signal.SignalHandler;
import io.greptime.common.util.Platform;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignalHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SignalHelper.class);
    private static final SignalAccessor SIGNAL_ACCESSOR = SignalHelper.getSignalAccessor0();

    public static boolean supportSignal() {
        return !Platform.isWindows() && SIGNAL_ACCESSOR != null;
    }

    public static boolean addSignal(Signal signal, List<SignalHandler> handlers) {
        if (SIGNAL_ACCESSOR != null) {
            SIGNAL_ACCESSOR.addSignal(signal.signalName(), handlers);
            return true;
        }
        return false;
    }

    private static SignalAccessor getSignalAccessor0() {
        return SignalHelper.hasSignal0() ? new SignalAccessor() : null;
    }

    private static boolean hasSignal0() {
        try {
            Class.forName("sun.misc.Signal");
            return true;
        }
        catch (Throwable t) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("sun.misc.Signal: unavailable.", t);
            }
            return false;
        }
    }

    private SignalHelper() {
    }

    static class SignalHandlerAdapter
    implements sun.misc.SignalHandler {
        private final sun.misc.Signal target;
        private final List<SignalHandler> handlers;

        public static void addSignal(SignalHandlerAdapter adapter) {
            sun.misc.Signal.handle(adapter.target, adapter);
        }

        public SignalHandlerAdapter(sun.misc.Signal target, List<SignalHandler> handlers) {
            this.target = target;
            this.handlers = handlers;
        }

        @Override
        public void handle(sun.misc.Signal signal) {
            try {
                if (!this.target.equals(signal)) {
                    return;
                }
                LOG.info("Handling signal {}.", (Object)signal);
                for (SignalHandler h : this.handlers) {
                    h.handle(signal.getName());
                }
            }
            catch (Throwable t) {
                LOG.error("Fail to handle signal: {}.", (Object)signal, (Object)t);
            }
        }
    }

    static class SignalAccessor {
        SignalAccessor() {
        }

        public void addSignal(String signalName, List<SignalHandler> handlers) {
            sun.misc.Signal signal = new sun.misc.Signal(signalName);
            SignalHandlerAdapter.addSignal(new SignalHandlerAdapter(signal, handlers));
        }
    }
}

