/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.push.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.push.PushMetricsDto;
import org.apache.hertzbeat.push.service.PushService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Metrics Push API")
@RestController
@RequestMapping(value={"/api/push"}, produces={"application/json"})
public class PushController {
    @Autowired
    private PushService pushService;

    @PostMapping
    @Operation(summary="Push metric data to hertzbeat", description="Push metric data to hertzbeat")
    public ResponseEntity<Message<Void>> pushMetrics(@RequestBody PushMetricsDto pushMetricsDto) {
        this.pushService.pushMetricsData(pushMetricsDto);
        return ResponseEntity.ok((Object)Message.success((String)"Push success"));
    }

    @GetMapping
    @Operation(summary="Get metric data for hertzbeat", description="Get metric data for hertzbeat")
    public ResponseEntity<Message<PushMetricsDto>> getMetrics(@Parameter(description="Monitor ID", example="6565463543") @RequestParam(value="id") Long id, @Parameter(description="Last pull time", example="6565463543") @RequestParam(value="time") Long time) {
        PushMetricsDto pushMetricsDto = this.pushService.getPushMetricData(id, time);
        return ResponseEntity.ok((Object)Message.success((Object)pushMetricsDto));
    }
}

