/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.unit.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.hertzbeat.collector.dispatch.unit.TimeLengthUnit;
import org.apache.hertzbeat.collector.dispatch.unit.UnitConvert;
import org.springframework.stereotype.Component;

@Component
public final class TimeLengthConvert
implements UnitConvert {
    @Override
    public String convert(String value, String originUnit, String newUnit) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        BigDecimal length = new BigDecimal(value);
        for (TimeLengthUnit timeLengthUnit : TimeLengthUnit.values()) {
            if (timeLengthUnit.getUnit().equals(originUnit.toUpperCase())) {
                length = length.multiply(new BigDecimal(timeLengthUnit.getScale()));
            }
            if (!timeLengthUnit.getUnit().equals(newUnit.toUpperCase())) continue;
            length = length.divide(new BigDecimal(timeLengthUnit.getScale()), 12, RoundingMode.HALF_UP);
        }
        return length.setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
    }

    @Override
    public boolean checkUnit(String unit) {
        if (unit == null || unit.isEmpty()) {
            return false;
        }
        for (TimeLengthUnit timeUnit : TimeLengthUnit.values()) {
            if (!timeUnit.getUnit().equals(unit.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

