/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.entrance;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.Channel;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hertzbeat.collector.dispatch.DispatchProperties;
import org.apache.hertzbeat.collector.dispatch.entrance.internal.CollectJobService;
import org.apache.hertzbeat.collector.dispatch.entrance.processor.CollectCyclicDataProcessor;
import org.apache.hertzbeat.collector.dispatch.entrance.processor.CollectOneTimeDataProcessor;
import org.apache.hertzbeat.collector.dispatch.entrance.processor.DeleteCyclicTaskProcessor;
import org.apache.hertzbeat.collector.dispatch.entrance.processor.GoCloseProcessor;
import org.apache.hertzbeat.collector.dispatch.entrance.processor.GoOfflineProcessor;
import org.apache.hertzbeat.collector.dispatch.entrance.processor.GoOnlineProcessor;
import org.apache.hertzbeat.collector.dispatch.entrance.processor.HeartbeatProcessor;
import org.apache.hertzbeat.collector.dispatch.timer.TimerDispatch;
import org.apache.hertzbeat.common.entity.dto.CollectorInfo;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.support.CommonThreadPool;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.remoting.RemotingClient;
import org.apache.hertzbeat.remoting.event.NettyEventListener;
import org.apache.hertzbeat.remoting.netty.NettyClientConfig;
import org.apache.hertzbeat.remoting.netty.NettyRemotingClient;
import org.apache.hertzbeat.remoting.netty.NettyRemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order
@ConditionalOnProperty(prefix="collector.dispatch.entrance.netty", name={"enabled"}, havingValue="true")
public class CollectServer
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(CollectServer.class);
    private final CollectJobService collectJobService;
    private final TimerDispatch timerDispatch;
    private RemotingClient remotingClient;
    private ScheduledExecutorService scheduledExecutor;

    public CollectServer(CollectJobService collectJobService, TimerDispatch timerDispatch, DispatchProperties properties, CommonThreadPool threadPool) {
        if (properties == null || properties.getEntrance() == null || properties.getEntrance().getNetty() == null) {
            log.error("init error, please config dispatch entrance netty props in application.yml");
            throw new IllegalArgumentException("please config dispatch entrance netty props");
        }
        DispatchProperties.EntranceProperties.NettyProperties nettyProperties = properties.getEntrance().getNetty();
        if (nettyProperties.getManagerHost() == null || nettyProperties.getManagerPort() == 0) {
            throw new IllegalArgumentException("please config dispatch entrance netty master host and port");
        }
        this.collectJobService = collectJobService;
        this.timerDispatch = timerDispatch;
        this.collectJobService.setCollectServer(this);
        this.init(properties, threadPool);
    }

    private void init(DispatchProperties properties, CommonThreadPool threadPool) {
        NettyClientConfig nettyClientConfig = new NettyClientConfig();
        DispatchProperties.EntranceProperties.NettyProperties nettyProperties = properties.getEntrance().getNetty();
        nettyClientConfig.setServerHost(nettyProperties.getManagerHost());
        nettyClientConfig.setServerPort(nettyProperties.getManagerPort());
        this.remotingClient = new NettyRemotingClient(nettyClientConfig, (NettyEventListener)new CollectNettyEventListener(), threadPool);
        this.remotingClient.registerProcessor(ClusterMsg.MessageType.HEARTBEAT, (NettyRemotingProcessor)new HeartbeatProcessor());
        this.remotingClient.registerProcessor(ClusterMsg.MessageType.ISSUE_CYCLIC_TASK, (NettyRemotingProcessor)new CollectCyclicDataProcessor(this));
        this.remotingClient.registerProcessor(ClusterMsg.MessageType.DELETE_CYCLIC_TASK, (NettyRemotingProcessor)new DeleteCyclicTaskProcessor(this));
        this.remotingClient.registerProcessor(ClusterMsg.MessageType.ISSUE_ONE_TIME_TASK, (NettyRemotingProcessor)new CollectOneTimeDataProcessor(this));
        this.remotingClient.registerProcessor(ClusterMsg.MessageType.GO_OFFLINE, (NettyRemotingProcessor)new GoOfflineProcessor());
        this.remotingClient.registerProcessor(ClusterMsg.MessageType.GO_ONLINE, (NettyRemotingProcessor)new GoOnlineProcessor());
        this.remotingClient.registerProcessor(ClusterMsg.MessageType.GO_CLOSE, (NettyRemotingProcessor)new GoCloseProcessor(this));
    }

    public void shutdown() {
        this.scheduledExecutor.shutdownNow();
        this.remotingClient.shutdown();
    }

    public CollectJobService getCollectJobService() {
        return this.collectJobService;
    }

    public void sendMsg(ClusterMsg.Message message) {
        this.remotingClient.sendMsg(message);
    }

    public void run(String ... args) throws Exception {
        this.remotingClient.start();
    }

    public class CollectNettyEventListener
    implements NettyEventListener {
        public void onChannelActive(Channel channel) {
            String identity = CollectServer.this.collectJobService.getCollectorIdentity();
            String mode = CollectServer.this.collectJobService.getCollectorMode();
            CollectorInfo collectorInfo = CollectorInfo.builder().name(identity).ip(IpDomainUtil.getLocalhostIp()).mode(mode).build();
            CollectServer.this.timerDispatch.goOnline();
            ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setIdentity(identity).setType(ClusterMsg.MessageType.GO_ONLINE).setMsg(JsonUtil.toJson((Object)collectorInfo)).build();
            CollectServer.this.sendMsg(message);
            if (CollectServer.this.scheduledExecutor == null) {
                ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
                    log.error("HeartBeat Scheduler has uncaughtException.");
                    log.error(throwable.getMessage(), throwable);
                }).setDaemon(true).setNameFormat("heartbeat-worker-%d").build();
                CollectServer.this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
                CollectServer.this.scheduledExecutor.scheduleAtFixedRate(() -> {
                    try {
                        ClusterMsg.Message heartbeat = ClusterMsg.Message.newBuilder().setIdentity(identity).setDirection(ClusterMsg.Direction.REQUEST).setType(ClusterMsg.MessageType.HEARTBEAT).build();
                        CollectServer.this.sendMsg(heartbeat);
                        log.info("collector send cluster server heartbeat, time: {}.", (Object)System.currentTimeMillis());
                    }
                    catch (Exception e) {
                        log.error("schedule send heartbeat to server error.{}", (Object)e.getMessage());
                    }
                }, 5L, 5L, TimeUnit.SECONDS);
            }
        }

        public void onChannelIdle(Channel channel) {
            log.info("handle idle event triggered. collector is going offline.");
        }
    }
}

