/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.httpsd.discovery;

import java.util.Objects;
import org.apache.hertzbeat.collector.collect.httpsd.constant.DiscoveryClientInstance;
import org.apache.hertzbeat.collector.collect.httpsd.discovery.DiscoveryClient;
import org.apache.hertzbeat.collector.collect.httpsd.discovery.impl.ConsulDiscoveryClient;
import org.apache.hertzbeat.collector.collect.httpsd.discovery.impl.NacosDiscoveryClient;
import org.apache.hertzbeat.common.entity.job.protocol.HttpsdProtocol;

public class DiscoveryClientManagement {
    public DiscoveryClient getClient(HttpsdProtocol httpsdProtocol) {
        return this.createClient(httpsdProtocol, DiscoveryClientInstance.getByName(httpsdProtocol.getDiscoveryClientTypeName()));
    }

    private DiscoveryClient createClient(HttpsdProtocol httpsdProtocol, DiscoveryClientInstance discoveryClientInstance) {
        if (Objects.equals((Object)discoveryClientInstance, (Object)DiscoveryClientInstance.NOT_SUPPORT)) {
            return null;
        }
        return this.doCreateClient(httpsdProtocol, discoveryClientInstance);
    }

    private DiscoveryClient doCreateClient(HttpsdProtocol httpsdProtocol, DiscoveryClientInstance discoveryClientInstance) {
        DiscoveryClient discoveryClient;
        switch (discoveryClientInstance) {
            case CONSUL: {
                discoveryClient = new ConsulDiscoveryClient();
                break;
            }
            case NACOS: {
                discoveryClient = new NacosDiscoveryClient();
                break;
            }
            default: {
                return null;
            }
        }
        discoveryClient.initClient(discoveryClient.buildConnectConfig(httpsdProtocol));
        return discoveryClient;
    }
}

