/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.Tag;
import org.apache.hertzbeat.manager.dao.TagDao;
import org.apache.hertzbeat.manager.service.TagService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TagServiceImpl
implements TagService {
    private static final Logger log = LoggerFactory.getLogger(TagServiceImpl.class);
    @Autowired
    private TagDao tagDao;

    @Override
    public void addTags(List<Tag> tags) {
        this.tagDao.saveAll(tags);
    }

    @Override
    public void modifyTag(Tag tag) {
        Optional tagOptional = this.tagDao.findById(tag.getId());
        if (!tagOptional.isPresent()) {
            throw new IllegalArgumentException("The tag is not existed");
        }
        tag.setTagValue(StringUtils.isEmpty((CharSequence)tag.getTagValue()) ? null : tag.getTagValue());
        this.tagDao.save(tag);
    }

    @Override
    public Page<Tag> getTags(Specification<Tag> specification, PageRequest pageRequest) {
        return this.tagDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void deleteTags(HashSet<Long> ids) {
        this.tagDao.deleteTagsByIdIn(ids);
    }

    @Override
    public List<Tag> listTag(Set<Long> ids) {
        return this.tagDao.findByIdIn(ids);
    }

    @Override
    public void deleteMonitorSystemTags(Monitor monitor) {
        if (CollectionUtils.isNotEmpty(monitor.getTags())) {
            List tags = monitor.getTags().stream().filter(tag -> tag.getType() == 0).collect(Collectors.toList());
            this.tagDao.deleteAll(tags);
        }
    }
}

