/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.obs.services.ObsClient;
import java.lang.reflect.Type;
import javax.annotation.Resource;
import org.apache.hertzbeat.manager.dao.GeneralConfigDao;
import org.apache.hertzbeat.manager.pojo.dto.ObjectStoreConfigChangeEvent;
import org.apache.hertzbeat.manager.pojo.dto.ObjectStoreDTO;
import org.apache.hertzbeat.manager.service.impl.AbstractGeneralConfigServiceImpl;
import org.apache.hertzbeat.manager.service.impl.ObsObjectStoreServiceImpl;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Order(value=-2147483648)
@Service
public class ObjectStoreConfigServiceImpl
extends AbstractGeneralConfigServiceImpl<ObjectStoreDTO<T>>
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ObjectStoreConfigServiceImpl.class);
    @Resource
    private DefaultListableBeanFactory beanFactory;
    @Resource
    private ApplicationContext ctx;
    private static final String BEAN_NAME = "ObjectStoreService";

    protected ObjectStoreConfigServiceImpl(GeneralConfigDao generalConfigDao, ObjectMapper objectMapper) {
        super(generalConfigDao, objectMapper);
    }

    @Override
    public String type() {
        return "oss";
    }

    @Override
    protected TypeReference<ObjectStoreDTO<T>> getTypeReference() {
        return new TypeReference<ObjectStoreDTO<T>>(){

            public Type getType() {
                return ObjectStoreDTO.class;
            }
        };
    }

    @Override
    public void handler(ObjectStoreDTO<T> config) {
        if (config != null) {
            if (config.getType() == ObjectStoreDTO.Type.OBS) {
                this.initObs(config);
            }
            this.ctx.publishEvent((ApplicationEvent)new ObjectStoreConfigChangeEvent(config));
        }
    }

    private void initObs(ObjectStoreDTO<T> config) {
        ObjectStoreDTO.ObsConfig obsConfig = (ObjectStoreDTO.ObsConfig)this.objectMapper.convertValue((Object)config.getConfig(), ObjectStoreDTO.ObsConfig.class);
        Assert.hasText((String)obsConfig.getAccessKey(), (String)"cannot find obs accessKey");
        Assert.hasText((String)obsConfig.getSecretKey(), (String)"cannot find obs secretKey");
        Assert.hasText((String)obsConfig.getEndpoint(), (String)"cannot find obs endpoint");
        Assert.hasText((String)obsConfig.getBucketName(), (String)"cannot find obs bucket name");
        ObsClient obsClient = new ObsClient(obsConfig.getAccessKey(), obsConfig.getSecretKey(), obsConfig.getEndpoint());
        this.beanFactory.destroySingleton(BEAN_NAME);
        this.beanFactory.registerSingleton(BEAN_NAME, (Object)new ObsObjectStoreServiceImpl(obsClient, obsConfig.getBucketName(), obsConfig.getSavePath()));
        log.info("obs store service init success.");
    }

    public void afterPropertiesSet() throws Exception {
        this.handler((ObjectStoreDTO)this.getConfig());
    }
}

