/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Resource;
import org.apache.hertzbeat.alert.AlerterProperties;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.common.support.event.SystemConfigChangeEvent;
import org.apache.hertzbeat.common.util.ResourceBundleUtil;
import org.apache.hertzbeat.manager.service.MailService;
import org.apache.hertzbeat.manager.service.NoticeConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class MailServiceImpl
implements MailService {
    private static final Logger log = LoggerFactory.getLogger(MailServiceImpl.class);
    @Resource
    private AlerterProperties alerterProperties;
    @Resource
    protected NoticeConfigService noticeConfigService;
    private ResourceBundle bundle = ResourceBundleUtil.getBundle("alerter");
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String buildAlertHtmlTemplate(Alert alert, NoticeTemplate noticeTemplate) throws IOException, TemplateException {
        Template templateMail = null;
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
        String monitorId = null;
        String monitorName = null;
        String monitorHost = null;
        if (alert.getTags() != null) {
            monitorId = alert.getTags().get("monitorId");
            monitorName = alert.getTags().get("monitorName");
            monitorHost = alert.getTags().get("monitorHost");
        }
        monitorId = monitorId == null ? "External Alarm, No ID" : monitorId;
        monitorName = monitorName == null ? "External Alarm, No Name" : monitorName;
        monitorHost = monitorHost == null ? "External Alarm, No Host" : monitorHost;
        HashMap<String, String> model = new HashMap<String, String>(16);
        model.put("nameTitle", this.bundle.getString("alerter.notify.title"));
        model.put("nameMonitorId", this.bundle.getString("alerter.notify.monitorId"));
        model.put("nameMonitorName", this.bundle.getString("alerter.notify.monitorName"));
        model.put("nameMonitorHost", this.bundle.getString("alerter.notify.monitorHost"));
        model.put("target", alert.getTarget());
        model.put("monitorId", monitorId);
        model.put("monitorName", monitorName);
        model.put("monitorHost", monitorHost);
        model.put("nameTarget", this.bundle.getString("alerter.notify.target"));
        model.put("nameConsole", this.bundle.getString("alerter.notify.console"));
        model.put("namePriority", this.bundle.getString("alerter.notify.priority"));
        model.put("priority", this.bundle.getString("alerter.priority." + alert.getPriority()));
        model.put("nameTriggerTime", this.bundle.getString("alerter.notify.triggerTime"));
        model.put("lastTriggerTime", this.simpleDateFormat.format(new Date(alert.getLastAlarmTime())));
        if (2 == alert.getStatus()) {
            model.put("nameRestoreTime", this.bundle.getString("alerter.notify.restoreTime"));
            model.put("restoreTime", this.simpleDateFormat.format(new Date(alert.getFirstAlarmTime())));
        }
        model.put("consoleUrl", this.alerterProperties.getConsoleUrl());
        model.put("nameContent", this.bundle.getString("alerter.notify.content"));
        model.put("content", alert.getContent());
        if (noticeTemplate == null) {
            noticeTemplate = this.noticeConfigService.getDefaultNoticeTemplateByType((byte)1);
        }
        if (noticeTemplate == null) {
            throw new NullPointerException("email does not have mapping default notice template");
        }
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        String templateName = "mailTemplate";
        stringLoader.putTemplate(templateName, noticeTemplate.getContent());
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        templateMail = cfg.getTemplate(templateName, Locale.CHINESE);
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)templateMail, model);
    }

    @EventListener(value={SystemConfigChangeEvent.class})
    public void onEvent(SystemConfigChangeEvent event) {
        log.info("{} receive system config change event: {}.", (Object)this.getClass().getName(), event.getSource());
        this.bundle = ResourceBundleUtil.getBundle("alerter");
    }
}

