/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hertzbeat.common.entity.manager.GeneralConfig;
import org.apache.hertzbeat.manager.dao.GeneralConfigDao;
import org.apache.hertzbeat.manager.service.GeneralConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

abstract class AbstractGeneralConfigServiceImpl<T>
implements GeneralConfigService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractGeneralConfigServiceImpl.class);
    protected final GeneralConfigDao generalConfigDao;
    protected final ObjectMapper objectMapper;

    protected AbstractGeneralConfigServiceImpl(GeneralConfigDao generalConfigDao, ObjectMapper objectMapper) {
        this.generalConfigDao = generalConfigDao;
        this.objectMapper = objectMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveConfig(T config) {
        try {
            String contentJson = this.objectMapper.writeValueAsString(config);
            GeneralConfig generalConfig2Save = GeneralConfig.builder().type(this.type()).content(contentJson).build();
            this.generalConfigDao.save(generalConfig2Save);
            log.info("Configuration saved successfully");
            this.handler(this.getConfig());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Configuration saved failed: " + e.getMessage());
        }
    }

    @Override
    public T getConfig() {
        GeneralConfig generalConfig = this.generalConfigDao.findByType(this.type());
        if (generalConfig == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(generalConfig.getContent(), this.getTypeReference());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Get configuration failed: " + e.getMessage());
        }
    }

    protected abstract TypeReference<T> getTypeReference();
}

