/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service;

import java.util.List;
import java.util.Set;
import org.apache.hertzbeat.alert.dao.AlertDefineDao;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.manager.service.AppService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=-2147483647)
public class AvailableAlertDefineInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(AvailableAlertDefineInit.class);
    @Autowired
    private AlertDefineDao alertDefineDao;
    @Autowired
    private AppService appService;

    public void run(String ... args) throws Exception {
        Set<String> apps = this.appService.getAllAppDefines().keySet();
        for (String app : apps) {
            try {
                List defines = this.alertDefineDao.queryAlertDefineByAppAndMetric(app, "availability");
                if (!defines.isEmpty()) continue;
                AlertDefine alertDefine = AlertDefine.builder().app(app).metric("availability").preset(true).times(2).enable(true).recoverNotice(false).priority((byte)0).template("${app} monitoring availability alert, code is ${code}").build();
                this.alertDefineDao.save((Object)alertDefine);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

