/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.scheduler;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hertzbeat.collector.dispatch.entrance.internal.CollectJobService;
import org.apache.hertzbeat.collector.dispatch.entrance.internal.CollectResponseEventListener;
import org.apache.hertzbeat.common.entity.dto.CollectorInfo;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.manager.Collector;
import org.apache.hertzbeat.common.entity.manager.CollectorMonitorBind;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.SnowFlakeIdGenerator;
import org.apache.hertzbeat.manager.dao.CollectorDao;
import org.apache.hertzbeat.manager.dao.CollectorMonitorBindDao;
import org.apache.hertzbeat.manager.dao.MonitorDao;
import org.apache.hertzbeat.manager.dao.ParamDao;
import org.apache.hertzbeat.manager.scheduler.AssignJobs;
import org.apache.hertzbeat.manager.scheduler.CollectJobScheduling;
import org.apache.hertzbeat.manager.scheduler.CollectorScheduling;
import org.apache.hertzbeat.manager.scheduler.ConsistentHash;
import org.apache.hertzbeat.manager.scheduler.SchedulerProperties;
import org.apache.hertzbeat.manager.scheduler.netty.ManageServer;
import org.apache.hertzbeat.manager.service.AppService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@AutoConfigureAfter(value={SchedulerProperties.class})
public class CollectorJobScheduler
implements CollectorScheduling,
CollectJobScheduling {
    private static final Logger log = LoggerFactory.getLogger(CollectorJobScheduler.class);
    private final Map<Long, Job> jobContentCache = new ConcurrentHashMap<Long, Job>(16);
    private final Map<Long, CollectResponseEventListener> eventListeners = new ConcurrentHashMap<Long, CollectResponseEventListener>(16);
    @Autowired
    private CollectorDao collectorDao;
    @Autowired
    private CollectorMonitorBindDao collectorMonitorBindDao;
    @Autowired
    private ConsistentHash consistentHash;
    @Autowired
    private CollectJobService collectJobService;
    @Autowired
    private AppService appService;
    @Autowired
    private MonitorDao monitorDao;
    @Autowired
    private ParamDao paramDao;
    private ManageServer manageServer;

    @Override
    public void collectorGoOnline(String identity, CollectorInfo collectorInfo) {
        Collector collector;
        if (identity == null) {
            log.error("identity can not be null if collector not existed");
            return;
        }
        Optional<Collector> collectorOptional = this.collectorDao.findCollectorByName(identity);
        if (collectorOptional.isPresent()) {
            collector = collectorOptional.get();
            if (collector.getStatus() == 0) {
                return;
            }
            collector.setStatus((byte)0);
            if (collectorInfo != null) {
                collector.setIp(collectorInfo.getIp());
                collector.setMode(collectorInfo.getMode());
            }
        } else {
            if (collectorInfo == null) {
                log.error("collectorInfo can not null when collector not existed");
                return;
            }
            collector = Collector.builder().name(identity).ip(collectorInfo.getIp()).mode(collectorInfo.getMode()).status((byte)0).build();
        }
        this.collectorDao.save(collector);
        ConsistentHash.Node node = new ConsistentHash.Node(identity, collector.getMode(), collector.getIp(), System.currentTimeMillis(), null);
        this.consistentHash.addNode(node);
        this.reBalanceCollectorAssignJobs();
        List<CollectorMonitorBind> binds = this.collectorMonitorBindDao.findCollectorMonitorBindsByCollector(identity);
        for (CollectorMonitorBind bind : binds) {
            Monitor monitor;
            Optional monitorOptional = this.monitorDao.findById(bind.getMonitorId());
            if (monitorOptional.isEmpty() || (monitor = (Monitor)monitorOptional.get()).getStatus() == 0) continue;
            try {
                Job appDefine = this.appService.getAppDefine(monitor.getApp());
                if ("prometheus".equals(monitor.getApp())) {
                    appDefine.setApp("_prometheus_" + monitor.getName());
                }
                appDefine.setMonitorId(monitor.getId());
                appDefine.setInterval(monitor.getIntervals().intValue());
                appDefine.setCyclic(true);
                appDefine.setTimestamp(System.currentTimeMillis());
                List<Param> params = this.paramDao.findParamsByMonitorId(monitor.getId());
                List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
                List<ParamDefine> paramDefaultValue = appDefine.getParams().stream().filter(item -> StringUtils.hasText((String)item.getDefaultValue())).toList();
                paramDefaultValue.forEach(defaultVar -> {
                    if (configmaps.stream().noneMatch(item -> item.getKey().equals(defaultVar.getField()))) {
                        Configmap configmap = new Configmap(defaultVar.getField(), defaultVar.getDefaultValue(), 1);
                        configmaps.add(configmap);
                    }
                });
                appDefine.setConfigmap(configmaps);
                long jobId = this.addAsyncCollectJob(appDefine, identity);
                monitor.setJobId(jobId);
                this.monitorDao.save(monitor);
            }
            catch (Exception e) {
                log.error("insert pinned monitor job: {} in collector: {} error,continue next monitor", new Object[]{monitor, identity, e});
            }
        }
    }

    @Override
    public void collectorGoOffline(String identity) {
        Optional<Collector> collectorOptional = this.collectorDao.findCollectorByName(identity);
        if (collectorOptional.isEmpty()) {
            log.info("the collector : {} not found.", (Object)identity);
            return;
        }
        Collector collector = collectorOptional.get();
        collector.setStatus((byte)1);
        this.collectorDao.save(collector);
        this.consistentHash.removeNode(identity);
        this.reBalanceCollectorAssignJobs();
        log.info("the collector: {} go offline success.", (Object)identity);
    }

    @Override
    public void reBalanceCollectorAssignJobs() {
        this.consistentHash.getAllNodes().entrySet().parallelStream().forEach(entry -> {
            String collectorName = (String)entry.getKey();
            AssignJobs assignJobs = ((ConsistentHash.Node)entry.getValue()).getAssignJobs();
            if (collectorName == null || assignJobs == null) {
                return;
            }
            if (assignJobs.getAddingJobs() != null && !assignJobs.getAddingJobs().isEmpty()) {
                HashSet<Long> addedJobIds = new HashSet<Long>(8);
                for (Long addingJobId : assignJobs.getAddingJobs()) {
                    Job job = this.jobContentCache.get(addingJobId);
                    if (job == null) {
                        log.error("assigning job {} content is null.", (Object)addingJobId);
                        continue;
                    }
                    addedJobIds.add(addingJobId);
                    if ("main-default-collector".equals(collectorName)) {
                        this.collectJobService.addAsyncCollectJob(job);
                        continue;
                    }
                    ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setDirection(ClusterMsg.Direction.REQUEST).setType(ClusterMsg.MessageType.ISSUE_CYCLIC_TASK).setMsg(JsonUtil.toJson(job)).build();
                    this.manageServer.sendMsg(collectorName, message);
                }
                assignJobs.addAssignJobs(addedJobIds);
                assignJobs.removeAddingJobs(addedJobIds);
            }
            if (assignJobs.getRemovingJobs() != null && !assignJobs.getRemovingJobs().isEmpty()) {
                if ("main-default-collector".equals(collectorName)) {
                    assignJobs.getRemovingJobs().forEach(jobId -> this.collectJobService.cancelAsyncCollectJob(jobId));
                } else {
                    ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setDirection(ClusterMsg.Direction.REQUEST).setType(ClusterMsg.MessageType.DELETE_CYCLIC_TASK).setMsg(JsonUtil.toJson(assignJobs.getRemovingJobs())).build();
                    this.manageServer.sendMsg(collectorName, message);
                }
                assignJobs.clearRemovingJobs();
            }
        });
    }

    @Override
    public boolean offlineCollector(String identity) {
        ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setType(ClusterMsg.MessageType.GO_OFFLINE).setDirection(ClusterMsg.Direction.REQUEST).setIdentity(identity).build();
        ClusterMsg.Message response = this.manageServer.sendMsgSync(identity, message);
        if (response == null || !String.valueOf(0).equals(response.getMsg())) {
            return false;
        }
        log.info("send offline collector message to {} success", (Object)identity);
        this.collectorGoOffline(identity);
        return true;
    }

    @Override
    public boolean onlineCollector(String identity) {
        Optional<Collector> collectorOptional = this.collectorDao.findCollectorByName(identity);
        if (collectorOptional.isEmpty()) {
            return false;
        }
        Collector collector = collectorOptional.get();
        ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setType(ClusterMsg.MessageType.GO_ONLINE).setDirection(ClusterMsg.Direction.REQUEST).setIdentity(identity).build();
        ClusterMsg.Message response = this.manageServer.sendMsgSync(identity, message);
        if (response == null || !String.valueOf(0).equals(response.getMsg())) {
            return false;
        }
        log.info("send online collector message to {} success", (Object)identity);
        CollectorInfo collectorInfo = CollectorInfo.builder().name(collector.getName()).ip(collector.getIp()).mode(collector.getMode()).build();
        this.collectorGoOnline(identity, collectorInfo);
        return true;
    }

    @Override
    public List<CollectRep.MetricsData> collectSyncJobData(Job job) {
        String dispatchKey = String.valueOf(job.getMonitorId());
        ConsistentHash.Node node = this.consistentHash.preDispatchJob(dispatchKey);
        if (node == null) {
            log.error("there is no collector online to assign job.");
            CollectRep.MetricsData metricsData = CollectRep.MetricsData.newBuilder().setCode(CollectRep.Code.FAIL).setMsg("no collector online to assign job").build();
            return Collections.singletonList(metricsData);
        }
        if ("main-default-collector".equals(node.getIdentity())) {
            return this.collectJobService.collectSyncJobData(job);
        }
        final LinkedList<CollectRep.MetricsData> metricsData = new LinkedList<CollectRep.MetricsData>();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setType(ClusterMsg.MessageType.ISSUE_ONE_TIME_TASK).setDirection(ClusterMsg.Direction.REQUEST).setMsg(JsonUtil.toJson(job)).build();
        boolean result = this.manageServer.sendMsg(node.getIdentity(), message);
        if (result) {
            CollectResponseEventListener listener = new CollectResponseEventListener(){

                public void response(List<CollectRep.MetricsData> responseMetrics) {
                    if (responseMetrics != null) {
                        metricsData.addAll(responseMetrics);
                    }
                    countDownLatch.countDown();
                }
            };
            this.eventListeners.put(job.getMonitorId(), listener);
        }
        try {
            countDownLatch.await(120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.info("The sync task runs for 120 seconds with no response and returns");
        }
        return metricsData;
    }

    @Override
    public List<CollectRep.MetricsData> collectSyncJobData(Job job, String collector) {
        ConsistentHash.Node node = this.consistentHash.getNode(collector);
        if (node == null) {
            log.error("there is no collector online to assign job.");
            CollectRep.MetricsData metricsData = CollectRep.MetricsData.newBuilder().setCode(CollectRep.Code.FAIL).setMsg("the collector is offline and cannot assign job").build();
            return Collections.singletonList(metricsData);
        }
        if ("main-default-collector".equals(node.getIdentity())) {
            return this.collectJobService.collectSyncJobData(job);
        }
        final LinkedList<CollectRep.MetricsData> metricsData = new LinkedList<CollectRep.MetricsData>();
        ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setType(ClusterMsg.MessageType.ISSUE_ONE_TIME_TASK).setDirection(ClusterMsg.Direction.REQUEST).setMsg(JsonUtil.toJson(job)).build();
        boolean result = this.manageServer.sendMsg(node.getIdentity(), message);
        if (result) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            CollectResponseEventListener listener = new CollectResponseEventListener(){

                public void response(List<CollectRep.MetricsData> responseMetrics) {
                    if (responseMetrics != null) {
                        metricsData.addAll(responseMetrics);
                    }
                    countDownLatch.countDown();
                }
            };
            this.eventListeners.put(job.getMonitorId(), listener);
            try {
                countDownLatch.await(120L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                log.info("The sync task runs for 120 seconds with no response and returns");
            }
        }
        return metricsData;
    }

    @Override
    public long addAsyncCollectJob(Job job, String collector) {
        ConsistentHash.Node node;
        long jobId = SnowFlakeIdGenerator.generateId();
        job.setId(jobId);
        this.jobContentCache.put(jobId, job);
        if (collector == null) {
            String dispatchKey = String.valueOf(job.getMonitorId());
            node = this.consistentHash.dispatchJob(dispatchKey, jobId);
            if (node == null) {
                log.error("there is no collector online to assign job.");
                return jobId;
            }
        } else {
            node = this.consistentHash.getNode(collector);
            if (node == null) {
                log.error("there is no collector name: {} online to assign job.", (Object)collector);
                return jobId;
            }
            node.getAssignJobs().addPinnedJob(jobId);
        }
        if ("main-default-collector".equals(node.getIdentity())) {
            this.collectJobService.addAsyncCollectJob(job);
        } else {
            ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setType(ClusterMsg.MessageType.ISSUE_CYCLIC_TASK).setDirection(ClusterMsg.Direction.REQUEST).setMsg(JsonUtil.toJson(job)).build();
            this.manageServer.sendMsg(node.getIdentity(), message);
        }
        return jobId;
    }

    @Override
    public long updateAsyncCollectJob(Job modifyJob) {
        long preJobId = modifyJob.getId();
        long newJobId = this.addAsyncCollectJob(modifyJob, null);
        this.jobContentCache.remove(preJobId);
        this.cancelAsyncCollectJob(preJobId);
        return newJobId;
    }

    @Override
    public long updateAsyncCollectJob(Job modifyJob, String collector) {
        long preJobId = modifyJob.getId();
        long newJobId = this.addAsyncCollectJob(modifyJob, collector);
        this.jobContentCache.remove(preJobId);
        this.cancelAsyncCollectJob(preJobId);
        return newJobId;
    }

    @Override
    public void cancelAsyncCollectJob(Long jobId) {
        if (jobId == null) {
            return;
        }
        for (ConsistentHash.Node node : this.consistentHash.getAllNodes().values()) {
            AssignJobs assignJobs = node.getAssignJobs();
            if (!assignJobs.getPinnedJobs().remove(jobId) && !assignJobs.getJobs().remove(jobId) && !assignJobs.getAddingJobs().remove(jobId)) continue;
            node.removeVirtualNodeJob(jobId);
            if ("main-default-collector".equals(node.getIdentity())) {
                this.collectJobService.cancelAsyncCollectJob(jobId);
                break;
            }
            ClusterMsg.Message deleteMessage = ClusterMsg.Message.newBuilder().setType(ClusterMsg.MessageType.DELETE_CYCLIC_TASK).setDirection(ClusterMsg.Direction.REQUEST).setMsg(JsonUtil.toJson(List.of(jobId))).build();
            this.manageServer.sendMsg(node.getIdentity(), deleteMessage);
            break;
        }
    }

    @Override
    public void collectSyncJobResponse(List<CollectRep.MetricsData> metricsDataList) {
        if (metricsDataList.isEmpty()) {
            return;
        }
        CollectRep.MetricsData metricsData = metricsDataList.get(0);
        long monitorId = metricsData.getId();
        CollectResponseEventListener eventListener = this.eventListeners.remove(monitorId);
        if (eventListener != null) {
            eventListener.response(metricsDataList);
        }
    }

    public void setManageServer(ManageServer manageServer) {
        this.manageServer = manageServer;
    }
}

