/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.manager.service.TagService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Tag Manage API")
@RestController
@RequestMapping(path={"/api/tag"}, produces={"application/json"})
public class TagController {
    @Autowired
    private TagService tagService;

    @PostMapping
    @Operation(summary="Add Tag", description="Add Tag")
    public ResponseEntity<Message<Void>> addNewTags(@Valid @RequestBody List<org.apache.hertzbeat.common.entity.manager.Tag> tags) {
        tags = tags.stream().peek(tag -> {
            tag.setType((byte)1);
            tag.setId(null);
        }).distinct().collect(Collectors.toList());
        this.tagService.addTags(tags);
        return ResponseEntity.ok(Message.success("Add success"));
    }

    @PutMapping
    @Operation(summary="Modify an existing tag", description="Modify an existing tag")
    public ResponseEntity<Message<Void>> modifyMonitor(@Valid @RequestBody org.apache.hertzbeat.common.entity.manager.Tag tag) {
        if (tag.getId() == null || tag.getName() == null) {
            throw new IllegalArgumentException("The Tag not exist.");
        }
        this.tagService.modifyTag(tag);
        return ResponseEntity.ok(Message.success("Modify success"));
    }

    @GetMapping
    @Operation(summary="Get tags information", description="Obtain label information based on conditions")
    public ResponseEntity<Message<Page<org.apache.hertzbeat.common.entity.manager.Tag>>> getTags(@Parameter(description="Tag content search", example="status") @RequestParam(required=false) String search, @Parameter(description="Tag type", example="0") @RequestParam(required=false) Byte type, @Parameter(description="List current page", example="0") @RequestParam(defaultValue="0") int pageIndex, @Parameter(description="Number of list pagination", example="8") @RequestParam(defaultValue="8") int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            if (type != null) {
                Predicate predicateApp = criteriaBuilder.equal((Expression)root.get("type"), (Object)type);
                andList.add(predicateApp);
            }
            Predicate[] andPredicates = new Predicate[andList.size()];
            Predicate andPredicate = criteriaBuilder.and(andList.toArray(andPredicates));
            ArrayList<Predicate> orList = new ArrayList<Predicate>();
            if (search != null && !search.isEmpty()) {
                Predicate predicateName = criteriaBuilder.like((Expression)root.get("name"), "%" + search + "%");
                orList.add(predicateName);
                Predicate predicateValue = criteriaBuilder.like((Expression)root.get("tagValue"), "%" + search + "%");
                orList.add(predicateValue);
            }
            Predicate[] orPredicates = new Predicate[orList.size()];
            Predicate orPredicate = criteriaBuilder.or(orList.toArray(orPredicates));
            if (andPredicates.length == 0 && orPredicates.length == 0) {
                return query.where(new Predicate[0]).getRestriction();
            }
            if (andPredicates.length == 0) {
                return orPredicate;
            }
            if (orPredicates.length == 0) {
                return andPredicate;
            }
            return query.where(new Predicate[]{andPredicate, orPredicate}).getRestriction();
        };
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize);
        Page<org.apache.hertzbeat.common.entity.manager.Tag> alertPage = this.tagService.getTags((Specification<org.apache.hertzbeat.common.entity.manager.Tag>)specification, pageRequest);
        Message<Page<org.apache.hertzbeat.common.entity.manager.Tag>> message = Message.success(alertPage);
        return ResponseEntity.ok(message);
    }

    @DeleteMapping
    @Operation(summary="Delete tags based on ID", description="Delete tags based on ID")
    public ResponseEntity<Message<Void>> deleteTags(@Parameter(description="TAG IDs ", example="6565463543") @RequestParam(required=false) List<Long> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.tagService.deleteTags(new HashSet<Long>(ids));
        }
        return ResponseEntity.ok(Message.success("Delete success"));
    }
}

