/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeRule;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.manager.service.NoticeConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Notification Config API")
@RestController
@RequestMapping(value={"/api/notice"}, produces={"application/json"})
public class NoticeConfigController {
    @Autowired
    private NoticeConfigService noticeConfigService;

    @PostMapping(path={"/receiver"})
    @Operation(summary="Add a recipient", description="Add a recipient")
    public ResponseEntity<Message<Void>> addNewNoticeReceiver(@Valid @RequestBody NoticeReceiver noticeReceiver) {
        this.noticeConfigService.addReceiver(noticeReceiver);
        return ResponseEntity.ok(Message.success("Add success"));
    }

    @PutMapping(path={"/receiver"})
    @Operation(summary="Modify existing recipient information", description="Modify existing recipient information")
    public ResponseEntity<Message<Void>> editNoticeReceiver(@Valid @RequestBody NoticeReceiver noticeReceiver) {
        this.noticeConfigService.editReceiver(noticeReceiver);
        return ResponseEntity.ok(Message.success("Edit success"));
    }

    @DeleteMapping(path={"/receiver/{id}"})
    @Operation(summary="Delete existing recipient information", description="Delete existing recipient information")
    public ResponseEntity<Message<Void>> deleteNoticeReceiver(@Parameter(description="en: Recipient ID", example="6565463543") @PathVariable(value="id") Long receiverId) {
        NoticeReceiver noticeReceiver = this.noticeConfigService.getReceiverById(receiverId);
        if (noticeReceiver == null) {
            return ResponseEntity.ok(Message.success("The relevant information of the recipient could not be found, please check whether the parameters are correct"));
        }
        this.noticeConfigService.deleteReceiver(receiverId);
        return ResponseEntity.ok(Message.success("Delete success"));
    }

    @GetMapping(path={"/receivers"})
    @Operation(summary="Get a list of message notification recipients based on query filter items", description="Get a list of message notification recipients based on query filter items")
    public ResponseEntity<Message<List<NoticeReceiver>>> getReceivers(@Parameter(description="en: Recipient name,support fuzzy query", example="tom") @RequestParam(required=false) String name) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (name != null && !name.isEmpty()) {
                Predicate predicateName = criteriaBuilder.like((Expression)root.get("name"), "%" + name + "%");
                predicate = criteriaBuilder.and(new Predicate[]{predicateName});
            }
            return predicate;
        };
        List<NoticeReceiver> receivers = this.noticeConfigService.getNoticeReceivers((Specification<NoticeReceiver>)specification);
        Message<List<NoticeReceiver>> message = Message.success(receivers);
        return ResponseEntity.ok(message);
    }

    @PostMapping(path={"/rule"})
    @Operation(summary="Add a notification policy", description="Add a notification policy")
    public ResponseEntity<Message<Void>> addNewNoticeRule(@Valid @RequestBody NoticeRule noticeRule) {
        this.noticeConfigService.addNoticeRule(noticeRule);
        return ResponseEntity.ok(Message.success("Add success"));
    }

    @PutMapping(path={"/rule"})
    @Operation(summary="Modify existing notification policy information", description="Modify existing notification policy information")
    public ResponseEntity<Message<Void>> editNoticeRule(@Valid @RequestBody NoticeRule noticeRule) {
        this.noticeConfigService.editNoticeRule(noticeRule);
        return ResponseEntity.ok(Message.success("Edit success"));
    }

    @DeleteMapping(path={"/rule/{id}"})
    @Operation(summary="Delete existing notification policy information", description="Delete existing notification policy information")
    public ResponseEntity<Message<Void>> deleteNoticeRule(@Parameter(description="en: Notification Policy ID", example="6565463543") @PathVariable(value="id") Long ruleId) {
        NoticeRule noticeRule = this.noticeConfigService.getNoticeRulesById(ruleId);
        if (noticeRule == null) {
            return ResponseEntity.ok(Message.success("The specified notification rule could not be queried, please check whether the parameters are correct"));
        }
        this.noticeConfigService.deleteNoticeRule(ruleId);
        return ResponseEntity.ok(Message.success("Delete success"));
    }

    @GetMapping(path={"/rules"})
    @Operation(summary="Get a list of message notification policies based on query filter items", description="Get a list of message notification policies based on query filter items")
    public ResponseEntity<Message<List<NoticeRule>>> getRules(@Parameter(description="en: Recipient name", example="rule1") @RequestParam(required=false) String name) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (name != null && !name.isEmpty()) {
                Predicate predicateName = criteriaBuilder.like((Expression)root.get("name"), "%" + name + "%");
                predicate = criteriaBuilder.and(new Predicate[]{predicateName});
            }
            return predicate;
        };
        List<NoticeRule> receiverPage = this.noticeConfigService.getNoticeRules((Specification<NoticeRule>)specification);
        Message<List<NoticeRule>> message = Message.success(receiverPage);
        return ResponseEntity.ok(message);
    }

    @PostMapping(path={"/template"})
    @Operation(summary="Add a notification template", description="Add a notification template")
    public ResponseEntity<Message<Void>> addNewNoticeTemplate(@Valid @RequestBody NoticeTemplate noticeTemplate) {
        this.noticeConfigService.addNoticeTemplate(noticeTemplate);
        return ResponseEntity.ok(Message.success("Add success"));
    }

    @PutMapping(path={"/template"})
    @Operation(summary="Modify existing notification template information", description="Modify existing notification template information")
    public ResponseEntity<Message<Void>> editNoticeTemplate(@Valid @RequestBody NoticeTemplate noticeTemplate) {
        this.noticeConfigService.editNoticeTemplate(noticeTemplate);
        return ResponseEntity.ok(Message.success("Edit success"));
    }

    @DeleteMapping(path={"/template/{id}"})
    @Operation(summary="Delete existing notification template information", description="Delete existing notification template information")
    public ResponseEntity<Message<Void>> deleteNoticeTemplate(@Parameter(description="en: Notification template ID", example="6565463543") @PathVariable(value="id") Long templateId) {
        Optional<NoticeTemplate> noticeTemplate = this.noticeConfigService.getNoticeTemplatesById(templateId);
        if (noticeTemplate.isEmpty()) {
            return ResponseEntity.ok(Message.success("The specified notification template could not be queried, please check whether the parameters are correct"));
        }
        this.noticeConfigService.deleteNoticeTemplate(templateId);
        return ResponseEntity.ok(Message.success("Delete success"));
    }

    @GetMapping(path={"/templates"})
    @Operation(summary="Get a list of message notification templates based on query filter items", description="Get a list of message notification templates based on query filter items")
    public ResponseEntity<Message<List<NoticeTemplate>>> getTemplates(@Parameter(description="Template name,support fuzzy query", example="rule1") @RequestParam(required=false) String name) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (name != null && !"".equals(name)) {
                Predicate predicateName = criteriaBuilder.like((Expression)root.get("name"), "%" + name + "%");
                predicate = criteriaBuilder.and(new Predicate[]{predicateName});
            }
            return predicate;
        };
        List<NoticeTemplate> templatePage = this.noticeConfigService.getNoticeTemplates((Specification<NoticeTemplate>)specification);
        Message<List<NoticeTemplate>> message = Message.success(templatePage);
        return ResponseEntity.ok(message);
    }

    @PostMapping(path={"/receiver/send-test-msg"})
    @Operation(summary="Send test msg to receiver", description="Send test msg to receiver")
    public ResponseEntity<Message<Void>> sendTestMsg(@Valid @RequestBody NoticeReceiver noticeReceiver) {
        boolean sendFlag = this.noticeConfigService.sendTestMsg(noticeReceiver);
        if (sendFlag) {
            return ResponseEntity.ok(Message.success());
        }
        return ResponseEntity.ok(Message.fail((byte)15, "Notify service not available, please check config!"));
    }
}

