/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import com.usthe.sureness.provider.SurenessAccount;
import com.usthe.sureness.provider.SurenessAccountProvider;
import com.usthe.sureness.provider.ducument.DocumentAccountProvider;
import com.usthe.sureness.util.JsonWebTokenUtil;
import com.usthe.sureness.util.Md5Util;
import io.jsonwebtoken.Claims;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.manager.pojo.dto.LoginDto;
import org.apache.hertzbeat.manager.pojo.dto.RefreshTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Auth Manage API")
@RestController
@RequestMapping(value={"/api/account/auth"}, produces={"application/json"})
public class AccountController {
    private static final Logger log = LoggerFactory.getLogger(AccountController.class);
    private static final long PERIOD_TIME = 3600L;
    private SurenessAccountProvider accountProvider = new DocumentAccountProvider();

    @PostMapping(value={"/form"})
    @Operation(summary="Account password login to obtain associated user information", description="Account password login to obtain associated user information")
    public ResponseEntity<Message<Map<String, String>>> authGetToken(@Valid @RequestBody LoginDto loginDto) {
        SurenessAccount account = this.accountProvider.loadAccount(loginDto.getIdentifier());
        if (account == null || account.getPassword() == null) {
            return ResponseEntity.ok(Message.fail((byte)5, "Incorrect Account or Password"));
        }
        String password = loginDto.getCredential();
        if (account.getSalt() != null) {
            password = Md5Util.md5((String)(password + account.getSalt()));
        }
        if (!account.getPassword().equals(password)) {
            return ResponseEntity.ok(Message.fail((byte)5, "Incorrect Account or Password"));
        }
        if (account.isDisabledAccount() || account.isExcessiveAttempts()) {
            return ResponseEntity.ok(Message.fail((byte)5, "Expired or Illegal Account"));
        }
        List roles = account.getOwnRoles();
        String issueToken = JsonWebTokenUtil.issueJwt((String)loginDto.getIdentifier(), (Long)3600L, (List)roles);
        HashMap<String, Boolean> customClaimMap = new HashMap<String, Boolean>(1);
        customClaimMap.put("refresh", true);
        String issueRefresh = JsonWebTokenUtil.issueJwt((String)loginDto.getIdentifier(), (Long)115200L, customClaimMap);
        HashMap<String, String> resp = new HashMap<String, String>(2);
        resp.put("token", issueToken);
        resp.put("refreshToken", issueRefresh);
        resp.put("role", JsonUtil.toJson(roles));
        return ResponseEntity.ok(Message.success(resp));
    }

    @GetMapping(value={"/refresh/{refreshToken}"})
    @Operation(summary="Use refresh TOKEN to re-acquire TOKEN", description="Use refresh TOKEN to re-acquire TOKEN")
    public ResponseEntity<Message<RefreshTokenResponse>> refreshToken(@Parameter(description="Refresh TOKEN", example="xxx") @PathVariable(value="refreshToken") @NotNull String refreshToken) {
        try {
            Claims claims = JsonWebTokenUtil.parseJwt((String)refreshToken);
            String userId = String.valueOf(claims.getSubject());
            boolean isRefresh = (Boolean)claims.get("refresh", Boolean.class);
            if (userId == null || !isRefresh) {
                return ResponseEntity.ok(Message.fail((byte)5, "Illegal Refresh Token"));
            }
            SurenessAccount account = this.accountProvider.loadAccount(userId);
            if (account == null) {
                return ResponseEntity.ok(Message.fail((byte)5, "Not Exists This Token Mapping Account"));
            }
            List roles = account.getOwnRoles();
            String issueToken = this.issueToken(userId, roles, 3600L);
            String issueRefresh = this.issueToken(userId, roles, 115200L);
            RefreshTokenResponse response = new RefreshTokenResponse(issueToken, issueRefresh);
            return ResponseEntity.ok(Message.success(response));
        }
        catch (Exception e) {
            log.error("Exception occurred during token refresh: {}", (Object)e.getClass().getName(), (Object)e);
            return ResponseEntity.ok(Message.fail((byte)5, "Refresh Token Expired or Error"));
        }
    }

    private String issueToken(String userId, List<String> roles, long expirationMillis) {
        HashMap<String, Boolean> customClaimMap = new HashMap<String, Boolean>(1);
        customClaimMap.put("refresh", true);
        return JsonWebTokenUtil.issueJwt((String)userId, (Long)expirationMillis, roles, customClaimMap);
    }
}

