/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.smn.v2.SmnClient;
import com.huaweicloud.sdk.smn.v2.model.PublishMessageRequest;
import com.huaweicloud.sdk.smn.v2.model.PublishMessageRequestBody;
import com.huaweicloud.sdk.smn.v2.model.PublishMessageResponse;
import com.huaweicloud.sdk.smn.v2.region.SmnRegion;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.common.util.ResourceBundleUtil;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
final class HuaweiCloudSmnAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(HuaweiCloudSmnAlertNotifyHandlerImpl.class);
    private final ResourceBundle bundle = ResourceBundleUtil.getBundle("alerter");
    private final Map<String, SmnClient> smnClientMap = new ConcurrentHashMap<String, SmnClient>();

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        try {
            SmnClient smnClient = this.getSmnClient(receiver);
            PublishMessageRequest request = new PublishMessageRequest().withTopicUrn(receiver.getSmnTopicUrn());
            PublishMessageRequestBody body = new PublishMessageRequestBody().withSubject(this.bundle.getString("alerter.notify.title")).withMessage(this.renderContent(noticeTemplate, alert));
            request.withBody(body);
            PublishMessageResponse response = smnClient.publishMessage(request);
            log.debug("huaweiCloud smn alert response: {}", (Object)response);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[Huawei Cloud Smn Notify Error] " + e.getMessage());
        }
    }

    private SmnClient getSmnClient(NoticeReceiver receiver) {
        String key = receiver.getSmnProjectId() + receiver.getSmnAk() + receiver.getSmnSk() + receiver.getSmnRegion();
        if (this.smnClientMap.containsKey(key)) {
            return this.smnClientMap.get(key);
        }
        BasicCredentials auth = (BasicCredentials)((BasicCredentials)new BasicCredentials().withProjectId(receiver.getSmnProjectId()).withAk(receiver.getSmnAk())).withSk(receiver.getSmnSk());
        SmnClient smnAsyncClient = (SmnClient)SmnClient.newBuilder().withCredential((ICredential)auth).withRegion(SmnRegion.valueOf((String)receiver.getSmnRegion())).build();
        this.smnClientMap.put(key, smnAsyncClient);
        return smnAsyncClient;
    }

    @Override
    public byte type() {
        return 11;
    }
}

