/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.component.alerter.impl.CommonRobotNotifyResp;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
final class FlyBookAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(FlyBookAlertNotifyHandlerImpl.class);

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        try {
            FlyBookWebHookDto flyBookWebHookDto = new FlyBookWebHookDto();
            Content content = new Content();
            Post post = new Post();
            ZhCn zhCn = new ZhCn();
            content.setPost(post);
            post.setZhCn(zhCn);
            flyBookWebHookDto.setMsgType("post");
            ArrayList<List<FlyBookContent>> contents = new ArrayList<List<FlyBookContent>>();
            ArrayList<FlyBookContent> contents1 = new ArrayList<FlyBookContent>();
            FlyBookContent flyBookContent = new FlyBookContent();
            flyBookContent.setTag("text");
            flyBookContent.setText(this.renderContent(noticeTemplate, alert));
            contents1.add(flyBookContent);
            FlyBookContent bookContent = new FlyBookContent();
            bookContent.setTag("a");
            bookContent.setText(this.bundle.getString("alerter.notify.console"));
            bookContent.setHref(this.alerterProperties.getConsoleUrl());
            contents1.add(bookContent);
            contents.add(contents1);
            zhCn.setTitle("[" + this.bundle.getString("alerter.notify.title") + "]");
            zhCn.setContent(contents);
            flyBookWebHookDto.setContent(content);
            String webHookUrl = this.alerterProperties.getFlyBookWebhookUrl() + receiver.getWechatId();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity flyEntity = new HttpEntity((Object)flyBookWebHookDto, (MultiValueMap)headers);
            ResponseEntity entity = this.restTemplate.postForEntity(webHookUrl, (Object)flyEntity, CommonRobotNotifyResp.class, new Object[0]);
            if (entity.getStatusCode() == HttpStatus.OK) {
                assert (entity.getBody() != null);
                if (((CommonRobotNotifyResp)entity.getBody()).getCode() != null && ((CommonRobotNotifyResp)entity.getBody()).getCode() != 0) {
                    log.warn("Send feiShu webHook: {} Failed: {}", (Object)webHookUrl, (Object)((CommonRobotNotifyResp)entity.getBody()).getMsg());
                    throw new AlertNoticeException(((CommonRobotNotifyResp)entity.getBody()).getMsg());
                }
            } else {
                log.warn("Send feiShu webHook: {} Failed: {}", (Object)webHookUrl, entity.getBody());
                throw new AlertNoticeException("Http StatusCode " + entity.getStatusCode());
            }
            log.debug("Send feiShu webHook: {} Success", (Object)webHookUrl);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[FeiShu Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 6;
    }

    private static class FlyBookWebHookDto {
        private static final String MARKDOWN = "post";
        @JsonProperty(value="msg_type")
        private String msgType = "post";
        private Content content;

        public String getMsgType() {
            return this.msgType;
        }

        public Content getContent() {
            return this.content;
        }

        @JsonProperty(value="msg_type")
        public void setMsgType(String msgType) {
            this.msgType = msgType;
        }

        public void setContent(Content content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlyBookWebHookDto)) {
                return false;
            }
            FlyBookWebHookDto other = (FlyBookWebHookDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msgType = this.getMsgType();
            String other$msgType = other.getMsgType();
            if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
                return false;
            }
            Content this$content = this.getContent();
            Content other$content = other.getContent();
            return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FlyBookWebHookDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msgType = this.getMsgType();
            result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
            Content $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            return result;
        }

        public String toString() {
            return "FlyBookAlertNotifyHandlerImpl.FlyBookWebHookDto(msgType=" + this.getMsgType() + ", content=" + this.getContent() + ")";
        }
    }

    private static class Content {
        public Post post;

        public Post getPost() {
            return this.post;
        }

        public void setPost(Post post) {
            this.post = post;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Content)) {
                return false;
            }
            Content other = (Content)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Post this$post = this.getPost();
            Post other$post = other.getPost();
            return !(this$post == null ? other$post != null : !((Object)this$post).equals(other$post));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Content;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Post $post = this.getPost();
            result = result * 59 + ($post == null ? 43 : ((Object)$post).hashCode());
            return result;
        }

        public String toString() {
            return "FlyBookAlertNotifyHandlerImpl.Content(post=" + this.getPost() + ")";
        }
    }

    private static class Post {
        @JsonProperty(value="zh_cn")
        public ZhCn zhCn;

        public ZhCn getZhCn() {
            return this.zhCn;
        }

        @JsonProperty(value="zh_cn")
        public void setZhCn(ZhCn zhCn) {
            this.zhCn = zhCn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Post)) {
                return false;
            }
            Post other = (Post)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ZhCn this$zhCn = this.getZhCn();
            ZhCn other$zhCn = other.getZhCn();
            return !(this$zhCn == null ? other$zhCn != null : !((Object)this$zhCn).equals(other$zhCn));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Post;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ZhCn $zhCn = this.getZhCn();
            result = result * 59 + ($zhCn == null ? 43 : ((Object)$zhCn).hashCode());
            return result;
        }

        public String toString() {
            return "FlyBookAlertNotifyHandlerImpl.Post(zhCn=" + this.getZhCn() + ")";
        }
    }

    private static class ZhCn {
        public String title;
        public List<List<FlyBookContent>> content;

        public String getTitle() {
            return this.title;
        }

        public List<List<FlyBookContent>> getContent() {
            return this.content;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setContent(List<List<FlyBookContent>> content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZhCn)) {
                return false;
            }
            ZhCn other = (ZhCn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            List<List<FlyBookContent>> this$content = this.getContent();
            List<List<FlyBookContent>> other$content = other.getContent();
            return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ZhCn;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            List<List<FlyBookContent>> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            return result;
        }

        public String toString() {
            return "FlyBookAlertNotifyHandlerImpl.ZhCn(title=" + this.getTitle() + ", content=" + this.getContent() + ")";
        }
    }

    private static class FlyBookContent {
        public String tag;
        public String text;
        public String href;
        @JsonProperty(value="user_id")
        public String userId;
        @JsonProperty(value="user_name")
        public String userName;

        public String getTag() {
            return this.tag;
        }

        public String getText() {
            return this.text;
        }

        public String getHref() {
            return this.href;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setHref(String href) {
            this.href = href;
        }

        @JsonProperty(value="user_id")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="user_name")
        public void setUserName(String userName) {
            this.userName = userName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlyBookContent)) {
                return false;
            }
            FlyBookContent other = (FlyBookContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$href = this.getHref();
            String other$href = other.getHref();
            if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FlyBookContent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $href = this.getHref();
            result = result * 59 + ($href == null ? 43 : $href.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            return result;
        }

        public String toString() {
            return "FlyBookAlertNotifyHandlerImpl.FlyBookContent(tag=" + this.getTag() + ", text=" + this.getText() + ", href=" + this.getHref() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ")";
        }
    }
}

