/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.component.alerter.impl.CommonRobotNotifyResp;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
final class DingTalkRobotAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(DingTalkRobotAlertNotifyHandlerImpl.class);

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        try {
            DingTalkWebHookDto dingTalkWebHookDto = new DingTalkWebHookDto();
            MarkdownDTO markdownDTO = new MarkdownDTO();
            markdownDTO.setText(this.renderContent(noticeTemplate, alert));
            markdownDTO.setTitle(this.bundle.getString("alerter.notify.title"));
            dingTalkWebHookDto.setMarkdown(markdownDTO);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity httpEntity = new HttpEntity((Object)dingTalkWebHookDto, (MultiValueMap)headers);
            String webHookUrl = this.alerterProperties.getDingTalkWebhookUrl() + receiver.getAccessToken();
            ResponseEntity responseEntity = this.restTemplate.postForEntity(webHookUrl, (Object)httpEntity, CommonRobotNotifyResp.class, new Object[0]);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                assert (responseEntity.getBody() != null);
                if (((CommonRobotNotifyResp)responseEntity.getBody()).getErrCode() != 0) {
                    log.warn("Send dingTalk webHook: {} Failed: {}", (Object)webHookUrl, (Object)((CommonRobotNotifyResp)responseEntity.getBody()).getErrMsg());
                    throw new AlertNoticeException(((CommonRobotNotifyResp)responseEntity.getBody()).getErrMsg());
                }
            } else {
                log.warn("Send dingTalk webHook: {} Failed: {}", (Object)webHookUrl, responseEntity.getBody());
                throw new AlertNoticeException("Http StatusCode " + responseEntity.getStatusCode());
            }
            log.debug("Send dingTalk webHook: {} Success", (Object)webHookUrl);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[DingTalk Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 5;
    }

    private static class DingTalkWebHookDto {
        private static final String MARKDOWN = "markdown";
        private String msgtype = "markdown";
        private MarkdownDTO markdown;

        public String getMsgtype() {
            return this.msgtype;
        }

        public MarkdownDTO getMarkdown() {
            return this.markdown;
        }

        public void setMsgtype(String msgtype) {
            this.msgtype = msgtype;
        }

        public void setMarkdown(MarkdownDTO markdown) {
            this.markdown = markdown;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DingTalkWebHookDto)) {
                return false;
            }
            DingTalkWebHookDto other = (DingTalkWebHookDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msgtype = this.getMsgtype();
            String other$msgtype = other.getMsgtype();
            if (this$msgtype == null ? other$msgtype != null : !this$msgtype.equals(other$msgtype)) {
                return false;
            }
            MarkdownDTO this$markdown = this.getMarkdown();
            MarkdownDTO other$markdown = other.getMarkdown();
            return !(this$markdown == null ? other$markdown != null : !((Object)this$markdown).equals(other$markdown));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DingTalkWebHookDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msgtype = this.getMsgtype();
            result = result * 59 + ($msgtype == null ? 43 : $msgtype.hashCode());
            MarkdownDTO $markdown = this.getMarkdown();
            result = result * 59 + ($markdown == null ? 43 : ((Object)$markdown).hashCode());
            return result;
        }

        public String toString() {
            return "DingTalkRobotAlertNotifyHandlerImpl.DingTalkWebHookDto(msgtype=" + this.getMsgtype() + ", markdown=" + this.getMarkdown() + ")";
        }
    }

    private static class MarkdownDTO {
        private String text;
        private String title;

        public String getText() {
            return this.text;
        }

        public String getTitle() {
            return this.title;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarkdownDTO)) {
                return false;
            }
            MarkdownDTO other = (MarkdownDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            return !(this$title == null ? other$title != null : !this$title.equals(other$title));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MarkdownDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            return result;
        }

        public String toString() {
            return "DingTalkRobotAlertNotifyHandlerImpl.MarkdownDTO(text=" + this.getText() + ", title=" + this.getTitle() + ")";
        }
    }
}

