/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client;

import com.alibaba.nacos.common.http.client.HttpClientRequestInterceptor;
import com.alibaba.nacos.common.http.client.request.HttpClientRequest;
import com.alibaba.nacos.common.http.client.response.HttpClientResponse;
import com.alibaba.nacos.common.model.RequestHttpEntity;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;

public class InterceptingHttpClientRequest
implements HttpClientRequest {
    private final HttpClientRequest httpClientRequest;
    private final Iterator<HttpClientRequestInterceptor> interceptors;

    public InterceptingHttpClientRequest(HttpClientRequest httpClientRequest, Iterator<HttpClientRequestInterceptor> interceptors) {
        this.httpClientRequest = httpClientRequest;
        this.interceptors = interceptors;
    }

    @Override
    public HttpClientResponse execute(URI uri, String httpMethod, RequestHttpEntity requestHttpEntity) throws Exception {
        while (this.interceptors.hasNext()) {
            HttpClientRequestInterceptor nextInterceptor = this.interceptors.next();
            if (!nextInterceptor.isIntercept(uri, httpMethod, requestHttpEntity)) continue;
            return nextInterceptor.intercept();
        }
        return this.httpClientRequest.execute(uri, httpMethod, requestHttpEntity);
    }

    @Override
    public void close() throws IOException {
        this.httpClientRequest.close();
    }
}

