/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.http.conn.util.InetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class IpDomainUtil {
    private static final Logger log = LoggerFactory.getLogger(IpDomainUtil.class);
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("^[-\\w]+(\\.[-\\w]+)*$");
    private static final String LOCALHOST = "localhost";
    private static final Pattern DOMAIN_SCHEMA = Pattern.compile("^([hH][tT]{2}[pP]://|[hH][tT]{2}[pP][sS]://){1}[^\\s]*");

    private IpDomainUtil() {
    }

    public static boolean validateIpDomain(String ipDomain) {
        if (ipDomain == null || "".equals(ipDomain)) {
            return false;
        }
        if (LOCALHOST.equalsIgnoreCase(ipDomain = ipDomain.trim())) {
            return true;
        }
        if (InetAddressUtils.isIPv4Address((String)ipDomain)) {
            return true;
        }
        if (InetAddressUtils.isIPv6Address((String)ipDomain)) {
            return true;
        }
        return DOMAIN_PATTERN.matcher(ipDomain).matches();
    }

    public static boolean isHasSchema(String domainIp) {
        if (domainIp == null || "".equals(domainIp)) {
            return false;
        }
        return DOMAIN_SCHEMA.matcher(domainIp).matches();
    }

    public static String getLocalhostIp() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        return null;
    }

    public static String checkIpAddressType(String ipDomain) {
        if (StringUtils.hasText((String)ipDomain) && InetAddressUtils.isIPv6Address((String)ipDomain)) {
            return "ipv6";
        }
        return "ipv4";
    }

    public static String getCurrentHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

