/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntervalExpressionUtil {
    private static final Logger log = LoggerFactory.getLogger(IntervalExpressionUtil.class);
    private static final String SPLIT_OR = "\\|\\|";
    private static final String SPLIT_AND = ",";
    private static final String SPLIT_EQU_LEFT = "(";
    private static final String SPLIT_EQU_RIGHT = ")";
    private static final String SPLIT_EQ_LEFT = "[";
    private static final String SPLIT_EQ_RIGHT = "]";
    private static final String NEGATIVE = "-\u221e";
    private static final String POSITIVE = "+\u221e";

    private IntervalExpressionUtil() {
    }

    public static boolean validNumberIntervalExpress(Double numberValue, String expression) {
        if (expression == null || "".equals(expression)) {
            return true;
        }
        if (numberValue == null) {
            return false;
        }
        try {
            String[] expressions;
            for (String expr : expressions = expression.split(SPLIT_OR)) {
                String[] values = expr.substring(1, expr.length() - 1).split(SPLIT_AND);
                if (values.length != 2) continue;
                Double[] doubleValues = new Double[]{NEGATIVE.equals(values[0]) ? Double.valueOf(Double.MIN_VALUE) : Double.valueOf(Double.parseDouble(values[0])), POSITIVE.equals(values[1]) ? Double.valueOf(Double.MAX_VALUE) : Double.valueOf(Double.parseDouble(values[1]))};
                String startBracket = expr.substring(0, 1);
                String endBracket = expr.substring(expr.length() - 1);
                if (!(SPLIT_EQU_LEFT.equals(startBracket) ? (SPLIT_EQU_RIGHT.equals(endBracket) ? numberValue > doubleValues[0] && numberValue < doubleValues[1] : SPLIT_EQ_RIGHT.equals(endBracket) && numberValue > doubleValues[0] && numberValue <= doubleValues[1]) : SPLIT_EQ_LEFT.equals(startBracket) && (SPLIT_EQU_RIGHT.equals(endBracket) ? numberValue >= doubleValues[0] && numberValue < doubleValues[1] : SPLIT_EQ_RIGHT.equals(endBracket) && numberValue >= doubleValues[0] && numberValue <= doubleValues[1]))) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

