/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.support;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SpringContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static ConfigurableApplicationContext configurableApplicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextHolder.set(applicationContext);
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext context;
            configurableApplicationContext = context = (ConfigurableApplicationContext)applicationContext;
        }
    }

    private static void set(ApplicationContext applicationContext) {
        SpringContextHolder.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertApplicationContext();
        return applicationContext;
    }

    public static <T> T getBean(String beanName) {
        SpringContextHolder.assertApplicationContext();
        return (T)applicationContext.getBean(beanName);
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringContextHolder.assertApplicationContext();
        return (T)applicationContext.getBean(clazz);
    }

    public static void shutdown() {
        SpringContextHolder.assertApplicationContext();
        configurableApplicationContext.close();
    }

    public static boolean isActive() {
        if (configurableApplicationContext == null) {
            return false;
        }
        return configurableApplicationContext.isActive();
    }

    private static void assertApplicationContext() {
        if (null == applicationContext || null == configurableApplicationContext) {
            throw new RuntimeException("applicationContext is null, please inject the springContextHolder");
        }
    }
}

