/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleUtf8Control
extends ResourceBundle.Control {
    private static final Logger log = LoggerFactory.getLogger(ResourceBundleUtf8Control.class);
    private static final String JAVA_CLASS = "java.class";
    private static final String JAVA_PROPERTIES = "java.properties";
    private static final String SPILT = "://";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String bundleName = this.toBundleName(baseName, locale);
        ResourceBundle bundle = null;
        if (JAVA_CLASS.equals(format)) {
            try {
                Class<?> bundleClass = loader.loadClass(bundleName);
                if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                    throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
                }
                bundle = (ResourceBundle)bundleClass.newInstance();
            }
            catch (ClassNotFoundException bundleClass) {}
        } else if (JAVA_PROPERTIES.equals(format)) {
            InputStream stream;
            String resourceName = this.toResourceName0(bundleName, "properties");
            if (resourceName == null) {
                return null;
            }
            ClassLoader classLoader = loader;
            boolean reloadFlag = reload;
            try {
                stream = AccessController.doPrivileged(() -> {
                    InputStream is = null;
                    if (reloadFlag) {
                        URLConnection connection;
                        URL url = classLoader.getResource(resourceName);
                        if (url != null && (connection = url.openConnection()) != null) {
                            connection.setUseCaches(false);
                            is = connection.getInputStream();
                        }
                    } else {
                        is = classLoader.getResourceAsStream(resourceName);
                    }
                    return is;
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                }
                finally {
                    stream.close();
                }
            }
        } else {
            throw new IllegalArgumentException("unknown format: " + format);
        }
        return bundle;
    }

    private String toResourceName0(String bundleName, String suffix) {
        if (bundleName.contains(SPILT)) {
            return null;
        }
        return this.toResourceName(bundleName, suffix);
    }
}

