/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.queue.impl;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hertzbeat.common.config.CommonProperties;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.serialize.AlertDeserializer;
import org.apache.hertzbeat.common.serialize.AlertSerializer;
import org.apache.hertzbeat.common.serialize.KafkaMetricsDataDeserializer;
import org.apache.hertzbeat.common.serialize.KafkaMetricsDataSerializer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="kafka")
public class KafkaCommonDataQueue
implements CommonDataQueue,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(KafkaCommonDataQueue.class);
    private KafkaProducer<Long, CollectRep.MetricsData> metricsDataProducer;
    private KafkaProducer<Long, Alert> alertDataProducer;
    private KafkaConsumer<Long, Alert> alertDataConsumer;
    private KafkaConsumer<Long, CollectRep.MetricsData> metricsDataToAlertConsumer;
    private KafkaConsumer<Long, CollectRep.MetricsData> metricsDataToPersistentStorageConsumer;
    private KafkaConsumer<Long, CollectRep.MetricsData> metricsDataToRealTimeStorageConsumer;
    private final ReentrantLock lock1 = new ReentrantLock();
    private final ReentrantLock lock2 = new ReentrantLock();
    private final ReentrantLock lock3 = new ReentrantLock();
    private final ReentrantLock lock4 = new ReentrantLock();
    private final LinkedBlockingQueue<Alert> alertDataQueue;
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToAlertQueue;
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToPersistentStorageQueue;
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToRealTimeStorageQueue;
    private final CommonProperties.KafkaProperties kafka;

    public KafkaCommonDataQueue(CommonProperties properties) {
        if (properties == null || properties.getQueue() == null || properties.getQueue().getKafka() == null) {
            log.error("init error, please config common.queue.kafka props in application.yml");
            throw new IllegalArgumentException("please config common.queue.kafka props");
        }
        this.kafka = properties.getQueue().getKafka();
        this.alertDataQueue = new LinkedBlockingQueue();
        this.metricsDataToAlertQueue = new LinkedBlockingQueue();
        this.metricsDataToPersistentStorageQueue = new LinkedBlockingQueue();
        this.metricsDataToRealTimeStorageQueue = new LinkedBlockingQueue();
        this.initDataQueue();
    }

    private void initDataQueue() {
        try {
            HashMap<String, Object> producerConfig = new HashMap<String, Object>(3);
            producerConfig.put("bootstrap.servers", this.kafka.getServers());
            producerConfig.put("acks", "all");
            producerConfig.put("retries", 3);
            this.metricsDataProducer = new KafkaProducer(producerConfig, (Serializer)new LongSerializer(), (Serializer)new KafkaMetricsDataSerializer());
            this.alertDataProducer = new KafkaProducer(producerConfig, (Serializer)new LongSerializer(), (Serializer)new AlertSerializer());
            HashMap<String, Object> consumerConfig = new HashMap<String, Object>(4);
            consumerConfig.put("bootstrap.servers", this.kafka.getServers());
            consumerConfig.put("max.poll.records", "50");
            consumerConfig.put("enable.auto.commit", false);
            consumerConfig.put("max.poll.interval.ms", "900000");
            consumerConfig.put("group.id", "default-consumer");
            HashMap<String, String> alertConsumerConfig = new HashMap<String, String>(consumerConfig);
            alertConsumerConfig.put("group.id", "alert-consumer");
            this.alertDataConsumer = new KafkaConsumer(alertConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new AlertDeserializer());
            this.alertDataConsumer.subscribe(Collections.singletonList(this.kafka.getAlertsDataTopic()));
            HashMap<String, String> metricsToAlertConsumerConfig = new HashMap<String, String>(consumerConfig);
            metricsToAlertConsumerConfig.put("group.id", "metrics-alert-consumer");
            this.metricsDataToAlertConsumer = new KafkaConsumer(metricsToAlertConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.metricsDataToAlertConsumer.subscribe(Collections.singletonList(this.kafka.getMetricsDataTopic()));
            HashMap<String, String> metricsToPersistentConsumerConfig = new HashMap<String, String>(consumerConfig);
            metricsToPersistentConsumerConfig.put("group.id", "metrics-persistent-consumer");
            this.metricsDataToPersistentStorageConsumer = new KafkaConsumer(metricsToPersistentConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.metricsDataToPersistentStorageConsumer.subscribe(Collections.singletonList(this.kafka.getMetricsDataTopic()));
            HashMap<String, String> metricsToRealTimeConsumerConfig = new HashMap<String, String>(consumerConfig);
            metricsToRealTimeConsumerConfig.put("group.id", "metrics-memory-consumer");
            this.metricsDataToRealTimeStorageConsumer = new KafkaConsumer(metricsToRealTimeConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.metricsDataToRealTimeStorageConsumer.subscribe(Collections.singletonList(this.kafka.getMetricsDataTopic()));
        }
        catch (Exception e) {
            log.error("please config common.queue.kafka props correctly", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void sendAlertsData(Alert alert) {
        if (this.alertDataProducer != null) {
            this.alertDataProducer.send(new ProducerRecord(this.kafka.getAlertsDataTopic(), (Object)alert));
        } else {
            log.error("kafkaAlertProducer is not enable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Alert pollAlertsData() throws InterruptedException {
        Alert alert = this.alertDataQueue.poll();
        if (alert != null) {
            return alert;
        }
        this.lock1.lockInterruptibly();
        try {
            ConsumerRecords records = this.alertDataConsumer.poll(Duration.ofSeconds(1L));
            int index = 0;
            for (ConsumerRecord record : records) {
                if (index == 0) {
                    alert = (Alert)record.value();
                } else {
                    this.alertDataQueue.offer((Alert)record.value());
                }
                ++index;
            }
            this.alertDataConsumer.commitAsync();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            this.lock1.unlock();
        }
        return alert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() throws InterruptedException {
        CollectRep.MetricsData metricsData = this.metricsDataToAlertQueue.poll();
        if (metricsData != null) {
            return metricsData;
        }
        this.lock2.lockInterruptibly();
        try {
            ConsumerRecords records = this.metricsDataToAlertConsumer.poll(Duration.ofSeconds(1L));
            int index = 0;
            for (ConsumerRecord record : records) {
                if (index == 0) {
                    metricsData = (CollectRep.MetricsData)record.value();
                } else {
                    this.metricsDataToAlertQueue.offer((CollectRep.MetricsData)record.value());
                }
                ++index;
            }
            this.metricsDataToAlertConsumer.commitAsync();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            this.lock2.unlock();
        }
        return metricsData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollectRep.MetricsData pollMetricsDataToPersistentStorage() throws InterruptedException {
        CollectRep.MetricsData persistentStorageMetricsData = this.metricsDataToPersistentStorageQueue.poll();
        if (persistentStorageMetricsData != null) {
            return persistentStorageMetricsData;
        }
        this.lock3.lockInterruptibly();
        try {
            ConsumerRecords records = this.metricsDataToPersistentStorageConsumer.poll(Duration.ofSeconds(1L));
            int index = 0;
            for (ConsumerRecord record : records) {
                if (index == 0) {
                    persistentStorageMetricsData = (CollectRep.MetricsData)record.value();
                } else {
                    this.metricsDataToPersistentStorageQueue.offer((CollectRep.MetricsData)record.value());
                }
                ++index;
            }
            this.metricsDataToPersistentStorageConsumer.commitAsync();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            this.lock3.unlock();
        }
        return persistentStorageMetricsData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollectRep.MetricsData pollMetricsDataToRealTimeStorage() throws InterruptedException {
        CollectRep.MetricsData realTimeMetricsData = this.metricsDataToRealTimeStorageQueue.poll();
        if (realTimeMetricsData != null) {
            return realTimeMetricsData;
        }
        this.lock4.lockInterruptibly();
        try {
            ConsumerRecords records = this.metricsDataToRealTimeStorageConsumer.poll(Duration.ofSeconds(1L));
            int index = 0;
            for (ConsumerRecord record : records) {
                if (index == 0) {
                    realTimeMetricsData = (CollectRep.MetricsData)record.value();
                } else {
                    this.metricsDataToRealTimeStorageQueue.offer((CollectRep.MetricsData)record.value());
                }
                ++index;
            }
            this.metricsDataToRealTimeStorageConsumer.commitAsync();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            this.lock4.unlock();
        }
        return realTimeMetricsData;
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        if (this.metricsDataProducer != null) {
            this.metricsDataProducer.send(new ProducerRecord(this.kafka.getMetricsDataTopic(), (Object)metricsData));
        } else {
            log.error("metricsDataProducer is not enabled");
        }
    }

    public void destroy() throws Exception {
        if (this.metricsDataProducer != null) {
            this.metricsDataProducer.close();
        }
        if (this.alertDataProducer != null) {
            this.alertDataProducer.close();
        }
        if (this.alertDataConsumer != null) {
            this.alertDataConsumer.close();
        }
        if (this.metricsDataToAlertConsumer != null) {
            this.metricsDataToAlertConsumer.close();
        }
        if (this.metricsDataToPersistentStorageConsumer != null) {
            this.metricsDataToPersistentStorageConsumer.close();
        }
        if (this.metricsDataToRealTimeStorageConsumer != null) {
            this.metricsDataToRealTimeStorageConsumer.close();
        }
    }
}

