/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_tag_monitor_bind", indexes={@Index(name="index_tag_monitor", columnList="tag_id"), @Index(name="index_tag_monitor", columnList="monitor_id")})
@Schema(description="Tag Bind Monitor")
@EntityListeners(value={AuditingEntityListener.class})
public class TagMonitorBind {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="The primary key index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="TAG ID", example="87432674384", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(name="tag_id")
    private Long tagId;
    @Schema(title="Monitor task ID", example="87432674336", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(name="monitor_id")
    private Long monitorId;
    @Schema(title="Record create time", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static TagMonitorBindBuilder builder() {
        return new TagMonitorBindBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getTagId() {
        return this.tagId;
    }

    public Long getMonitorId() {
        return this.monitorId;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public void setMonitorId(Long monitorId) {
        this.monitorId = monitorId;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagMonitorBind)) {
            return false;
        }
        TagMonitorBind other = (TagMonitorBind)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tagId = this.getTagId();
        Long other$tagId = other.getTagId();
        if (this$tagId == null ? other$tagId != null : !((Object)this$tagId).equals(other$tagId)) {
            return false;
        }
        Long this$monitorId = this.getMonitorId();
        Long other$monitorId = other.getMonitorId();
        if (this$monitorId == null ? other$monitorId != null : !((Object)this$monitorId).equals(other$monitorId)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TagMonitorBind;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tagId = this.getTagId();
        result = result * 59 + ($tagId == null ? 43 : ((Object)$tagId).hashCode());
        Long $monitorId = this.getMonitorId();
        result = result * 59 + ($monitorId == null ? 43 : ((Object)$monitorId).hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "TagMonitorBind(id=" + this.getId() + ", tagId=" + this.getTagId() + ", monitorId=" + this.getMonitorId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public TagMonitorBind(Long id, Long tagId, Long monitorId, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.tagId = tagId;
        this.monitorId = monitorId;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public TagMonitorBind() {
    }

    public static class TagMonitorBindBuilder {
        private Long id;
        private Long tagId;
        private Long monitorId;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        TagMonitorBindBuilder() {
        }

        public TagMonitorBindBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TagMonitorBindBuilder tagId(Long tagId) {
            this.tagId = tagId;
            return this;
        }

        public TagMonitorBindBuilder monitorId(Long monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public TagMonitorBindBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public TagMonitorBindBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public TagMonitorBind build() {
            return new TagMonitorBind(this.id, this.tagId, this.monitorId, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "TagMonitorBind.TagMonitorBindBuilder(id=" + this.id + ", tagId=" + this.tagId + ", monitorId=" + this.monitorId + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

