/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Objects;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_tag")
@Schema(description="Tag Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class Tag {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Tag Primary key index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Tag Field", example="app", accessMode=Schema.AccessMode.READ_WRITE)
    @NotNull
    private String name;
    @Schema(title="Tag Value", example="23", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(length=2048)
    private String tagValue;
    @Schema(title="Tag Color", example="#ffff", accessMode=Schema.AccessMode.READ_WRITE)
    private String color;
    @Schema(title="Tag Color", example="Used for monitoring mysql", accessMode=Schema.AccessMode.READ_WRITE)
    private String description;
    @Schema(title="Tag type 0: Auto-generated monitor (monitorId,monitorName) 1: user-generated 2: system preset", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    @Max(value=3L)
    private @Min(value=0L) @Max(value=3L) byte type;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record create time", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.name, tag.name) && Objects.equals(this.tagValue, tag.tagValue);
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.name == null ? 0 : this.name.hashCode()) + (this.tagValue == null ? 0 : this.tagValue.hashCode());
        return hash;
    }

    public static TagBuilder builder() {
        return new TagBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public String getColor() {
        return this.color;
    }

    public String getDescription() {
        return this.description;
    }

    public byte getType() {
        return this.type;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTagValue(String tagValue) {
        this.tagValue = tagValue;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public String toString() {
        return "Tag(id=" + this.getId() + ", name=" + this.getName() + ", tagValue=" + this.getTagValue() + ", color=" + this.getColor() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public Tag(Long id, String name, String tagValue, String color, String description, byte type, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.tagValue = tagValue;
        this.color = color;
        this.description = description;
        this.type = type;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public Tag() {
    }

    public static class TagBuilder {
        private Long id;
        private String name;
        private String tagValue;
        private String color;
        private String description;
        private byte type;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        TagBuilder() {
        }

        public TagBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TagBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TagBuilder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public TagBuilder color(String color) {
            this.color = color;
            return this;
        }

        public TagBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TagBuilder type(byte type) {
            this.type = type;
            return this;
        }

        public TagBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public TagBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public TagBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public TagBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public Tag build() {
            return new Tag(this.id, this.name, this.tagValue, this.color, this.description, this.type, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "Tag.TagBuilder(id=" + this.id + ", name=" + this.name + ", tagValue=" + this.tagValue + ", color=" + this.color + ", description=" + this.description + ", type=" + this.type + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

