/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.hertzbeat.common.entity.manager.JsonByteListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.JsonLongListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.JsonStringListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.JsonTagListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.TagItem;
import org.apache.hertzbeat.common.entity.manager.ZonedDateTimeAttributeConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_notice_rule")
@Schema(description="Notify Policy Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class NoticeRule {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Notification Policy Entity Primary Key Index ID", description="Notification Policy Entity Primary Key Index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Policy name", description="Policy name", example="dispatch-1", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    @NotNull
    private @Size(max=100) @NotNull String name;
    @Schema(title="Recipient ID", description="Recipient ID", example="4324324", accessMode=Schema.AccessMode.READ_WRITE)
    @NotNull
    @Convert(converter=JsonLongListAttributeConverter.class)
    private List<Long> receiverId;
    @Schema(title="Recipient identification", description="Recipient identification", example="tom", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonStringListAttributeConverter.class)
    private List<String> receiverName;
    @Schema(title="Template ID", description="Template ID", example="4324324", accessMode=Schema.AccessMode.READ_WRITE)
    private Long templateId;
    @Schema(title="Template identification", description="Template identification", example="demo", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    private @Size(max=100) String templateName;
    @Schema(title="Whether to enable this policy", description="Whether to enable this policy", example="true", accessMode=Schema.AccessMode.READ_WRITE)
    private boolean enable = true;
    @Schema(title="Whether to forward all", description="Whether to forward all", example="false", accessMode=Schema.AccessMode.READ_WRITE)
    private boolean filterAll = true;
    @Schema(title="Filter the matching alarm level, empty is all alarm level 0: high -emergency- Urgent alarm - red 1: Medium -critical- Serious alarm - orange 2: Low -warning- Warning alarm - yellow", example="[1]", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonByteListAttributeConverter.class)
    private List<Byte> priorities;
    @Schema(description="Alarm information label(monitorId:xxx,monitorName:xxx)", example="{name: key1, value: value1}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonTagListAttributeConverter.class)
    @Column(length=2048)
    private List<TagItem> tags;
    @Schema(title="Day of the week, multiple, all or empty is daily 7: Sunday 1: Monday 2: Tuesday 3: Wednesday 4: Thursday 5: Friday 6: Saturday", example="[0,1]", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonByteListAttributeConverter.class)
    private List<Byte> days;
    @Schema(title="Limit time period start", example="00:00:00", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=ZonedDateTimeAttributeConverter.class)
    private ZonedDateTime periodStart;
    @Schema(title="Restricted time period end", example="23:59:59", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=ZonedDateTimeAttributeConverter.class)
    private ZonedDateTime periodEnd;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedBy
    private String modifier;
    @Schema(title="This record creation time (millisecond timestamp)", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static NoticeRuleBuilder builder() {
        return new NoticeRuleBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Long> getReceiverId() {
        return this.receiverId;
    }

    public List<String> getReceiverName() {
        return this.receiverName;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isFilterAll() {
        return this.filterAll;
    }

    public List<Byte> getPriorities() {
        return this.priorities;
    }

    public List<TagItem> getTags() {
        return this.tags;
    }

    public List<Byte> getDays() {
        return this.days;
    }

    public ZonedDateTime getPeriodStart() {
        return this.periodStart;
    }

    public ZonedDateTime getPeriodEnd() {
        return this.periodEnd;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReceiverId(List<Long> receiverId) {
        this.receiverId = receiverId;
    }

    public void setReceiverName(List<String> receiverName) {
        this.receiverName = receiverName;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setFilterAll(boolean filterAll) {
        this.filterAll = filterAll;
    }

    public void setPriorities(List<Byte> priorities) {
        this.priorities = priorities;
    }

    public void setTags(List<TagItem> tags) {
        this.tags = tags;
    }

    public void setDays(List<Byte> days) {
        this.days = days;
    }

    public void setPeriodStart(ZonedDateTime periodStart) {
        this.periodStart = periodStart;
    }

    public void setPeriodEnd(ZonedDateTime periodEnd) {
        this.periodEnd = periodEnd;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoticeRule)) {
            return false;
        }
        NoticeRule other = (NoticeRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isFilterAll() != other.isFilterAll()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$templateId = this.getTemplateId();
        Long other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !((Object)this$templateId).equals(other$templateId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Long> this$receiverId = this.getReceiverId();
        List<Long> other$receiverId = other.getReceiverId();
        if (this$receiverId == null ? other$receiverId != null : !((Object)this$receiverId).equals(other$receiverId)) {
            return false;
        }
        List<String> this$receiverName = this.getReceiverName();
        List<String> other$receiverName = other.getReceiverName();
        if (this$receiverName == null ? other$receiverName != null : !((Object)this$receiverName).equals(other$receiverName)) {
            return false;
        }
        String this$templateName = this.getTemplateName();
        String other$templateName = other.getTemplateName();
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        List<Byte> this$priorities = this.getPriorities();
        List<Byte> other$priorities = other.getPriorities();
        if (this$priorities == null ? other$priorities != null : !((Object)this$priorities).equals(other$priorities)) {
            return false;
        }
        List<TagItem> this$tags = this.getTags();
        List<TagItem> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<Byte> this$days = this.getDays();
        List<Byte> other$days = other.getDays();
        if (this$days == null ? other$days != null : !((Object)this$days).equals(other$days)) {
            return false;
        }
        ZonedDateTime this$periodStart = this.getPeriodStart();
        ZonedDateTime other$periodStart = other.getPeriodStart();
        if (this$periodStart == null ? other$periodStart != null : !((Object)this$periodStart).equals(other$periodStart)) {
            return false;
        }
        ZonedDateTime this$periodEnd = this.getPeriodEnd();
        ZonedDateTime other$periodEnd = other.getPeriodEnd();
        if (this$periodEnd == null ? other$periodEnd != null : !((Object)this$periodEnd).equals(other$periodEnd)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NoticeRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isFilterAll() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : ((Object)$templateId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Long> $receiverId = this.getReceiverId();
        result = result * 59 + ($receiverId == null ? 43 : ((Object)$receiverId).hashCode());
        List<String> $receiverName = this.getReceiverName();
        result = result * 59 + ($receiverName == null ? 43 : ((Object)$receiverName).hashCode());
        String $templateName = this.getTemplateName();
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        List<Byte> $priorities = this.getPriorities();
        result = result * 59 + ($priorities == null ? 43 : ((Object)$priorities).hashCode());
        List<TagItem> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<Byte> $days = this.getDays();
        result = result * 59 + ($days == null ? 43 : ((Object)$days).hashCode());
        ZonedDateTime $periodStart = this.getPeriodStart();
        result = result * 59 + ($periodStart == null ? 43 : ((Object)$periodStart).hashCode());
        ZonedDateTime $periodEnd = this.getPeriodEnd();
        result = result * 59 + ($periodEnd == null ? 43 : ((Object)$periodEnd).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "NoticeRule(id=" + this.getId() + ", name=" + this.getName() + ", receiverId=" + this.getReceiverId() + ", receiverName=" + this.getReceiverName() + ", templateId=" + this.getTemplateId() + ", templateName=" + this.getTemplateName() + ", enable=" + this.isEnable() + ", filterAll=" + this.isFilterAll() + ", priorities=" + this.getPriorities() + ", tags=" + this.getTags() + ", days=" + this.getDays() + ", periodStart=" + this.getPeriodStart() + ", periodEnd=" + this.getPeriodEnd() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public NoticeRule(Long id, String name, List<Long> receiverId, List<String> receiverName, Long templateId, String templateName, boolean enable, boolean filterAll, List<Byte> priorities, List<TagItem> tags, List<Byte> days, ZonedDateTime periodStart, ZonedDateTime periodEnd, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.receiverId = receiverId;
        this.receiverName = receiverName;
        this.templateId = templateId;
        this.templateName = templateName;
        this.enable = enable;
        this.filterAll = filterAll;
        this.priorities = priorities;
        this.tags = tags;
        this.days = days;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public NoticeRule() {
    }

    public static class NoticeRuleBuilder {
        private Long id;
        private String name;
        private List<Long> receiverId;
        private List<String> receiverName;
        private Long templateId;
        private String templateName;
        private boolean enable;
        private boolean filterAll;
        private List<Byte> priorities;
        private List<TagItem> tags;
        private List<Byte> days;
        private ZonedDateTime periodStart;
        private ZonedDateTime periodEnd;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        NoticeRuleBuilder() {
        }

        public NoticeRuleBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public NoticeRuleBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NoticeRuleBuilder receiverId(List<Long> receiverId) {
            this.receiverId = receiverId;
            return this;
        }

        public NoticeRuleBuilder receiverName(List<String> receiverName) {
            this.receiverName = receiverName;
            return this;
        }

        public NoticeRuleBuilder templateId(Long templateId) {
            this.templateId = templateId;
            return this;
        }

        public NoticeRuleBuilder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public NoticeRuleBuilder enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public NoticeRuleBuilder filterAll(boolean filterAll) {
            this.filterAll = filterAll;
            return this;
        }

        public NoticeRuleBuilder priorities(List<Byte> priorities) {
            this.priorities = priorities;
            return this;
        }

        public NoticeRuleBuilder tags(List<TagItem> tags) {
            this.tags = tags;
            return this;
        }

        public NoticeRuleBuilder days(List<Byte> days) {
            this.days = days;
            return this;
        }

        public NoticeRuleBuilder periodStart(ZonedDateTime periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        public NoticeRuleBuilder periodEnd(ZonedDateTime periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        public NoticeRuleBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public NoticeRuleBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public NoticeRuleBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public NoticeRuleBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public NoticeRule build() {
            return new NoticeRule(this.id, this.name, this.receiverId, this.receiverName, this.templateId, this.templateName, this.enable, this.filterAll, this.priorities, this.tags, this.days, this.periodStart, this.periodEnd, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "NoticeRule.NoticeRuleBuilder(id=" + this.id + ", name=" + this.name + ", receiverId=" + this.receiverId + ", receiverName=" + this.receiverName + ", templateId=" + this.templateId + ", templateName=" + this.templateName + ", enable=" + this.enable + ", filterAll=" + this.filterAll + ", priorities=" + this.priorities + ", tags=" + this.tags + ", days=" + this.days + ", periodStart=" + this.periodStart + ", periodEnd=" + this.periodEnd + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

