/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.alerter;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.hertzbeat.common.entity.manager.JsonByteListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.JsonTagListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.TagItem;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_alert_converge")
@Schema(description="Alert Converge Policy Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class AlertConverge {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Alert Converge Policy Entity Primary Key Index ID", description="Alert Converge Policy Entity Primary Key Index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Policy name", description="Policy name", example="converge-1", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    @NotNull
    private @Size(max=100) @NotNull String name;
    @Schema(title="Whether to enable this policy", description="Whether to enable this policy", example="true", accessMode=Schema.AccessMode.READ_WRITE)
    private boolean enable = true;
    @Schema(title="Whether to match all", description="Whether to match all", example="true", accessMode=Schema.AccessMode.READ_WRITE)
    private boolean matchAll = true;
    @Schema(title="Alarm Level 0:High-Emergency-Critical Alarm 1:Medium-Critical-Critical Alarm 2:Low-Warning-Warning", example="[1]", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonByteListAttributeConverter.class)
    private List<Byte> priorities;
    @Schema(description="Match the alarm information label(monitorId:xxx,monitorName:xxx)", example="{name: key1, value: value1}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonTagListAttributeConverter.class)
    @Column(length=2048)
    private List<TagItem> tags;
    @Schema(title="Repeat Alert Converge Time Range, unit s", example="600", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    private @Min(value=0L) Integer evalInterval;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedBy
    private String modifier;
    @Schema(title="This record creation time (millisecond timestamp)", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static AlertConvergeBuilder builder() {
        return new AlertConvergeBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public List<Byte> getPriorities() {
        return this.priorities;
    }

    public List<TagItem> getTags() {
        return this.tags;
    }

    public Integer getEvalInterval() {
        return this.evalInterval;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public void setPriorities(List<Byte> priorities) {
        this.priorities = priorities;
    }

    public void setTags(List<TagItem> tags) {
        this.tags = tags;
    }

    public void setEvalInterval(Integer evalInterval) {
        this.evalInterval = evalInterval;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertConverge)) {
            return false;
        }
        AlertConverge other = (AlertConverge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isMatchAll() != other.isMatchAll()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$evalInterval = this.getEvalInterval();
        Integer other$evalInterval = other.getEvalInterval();
        if (this$evalInterval == null ? other$evalInterval != null : !((Object)this$evalInterval).equals(other$evalInterval)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Byte> this$priorities = this.getPriorities();
        List<Byte> other$priorities = other.getPriorities();
        if (this$priorities == null ? other$priorities != null : !((Object)this$priorities).equals(other$priorities)) {
            return false;
        }
        List<TagItem> this$tags = this.getTags();
        List<TagItem> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertConverge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isMatchAll() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $evalInterval = this.getEvalInterval();
        result = result * 59 + ($evalInterval == null ? 43 : ((Object)$evalInterval).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Byte> $priorities = this.getPriorities();
        result = result * 59 + ($priorities == null ? 43 : ((Object)$priorities).hashCode());
        List<TagItem> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "AlertConverge(id=" + this.getId() + ", name=" + this.getName() + ", enable=" + this.isEnable() + ", matchAll=" + this.isMatchAll() + ", priorities=" + this.getPriorities() + ", tags=" + this.getTags() + ", evalInterval=" + this.getEvalInterval() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public AlertConverge(Long id, String name, boolean enable, boolean matchAll, List<Byte> priorities, List<TagItem> tags, Integer evalInterval, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.enable = enable;
        this.matchAll = matchAll;
        this.priorities = priorities;
        this.tags = tags;
        this.evalInterval = evalInterval;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public AlertConverge() {
    }

    public static class AlertConvergeBuilder {
        private Long id;
        private String name;
        private boolean enable;
        private boolean matchAll;
        private List<Byte> priorities;
        private List<TagItem> tags;
        private Integer evalInterval;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        AlertConvergeBuilder() {
        }

        public AlertConvergeBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AlertConvergeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AlertConvergeBuilder enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public AlertConvergeBuilder matchAll(boolean matchAll) {
            this.matchAll = matchAll;
            return this;
        }

        public AlertConvergeBuilder priorities(List<Byte> priorities) {
            this.priorities = priorities;
            return this;
        }

        public AlertConvergeBuilder tags(List<TagItem> tags) {
            this.tags = tags;
            return this;
        }

        public AlertConvergeBuilder evalInterval(Integer evalInterval) {
            this.evalInterval = evalInterval;
            return this;
        }

        public AlertConvergeBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AlertConvergeBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public AlertConvergeBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AlertConvergeBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public AlertConverge build() {
            return new AlertConverge(this.id, this.name, this.enable, this.matchAll, this.priorities, this.tags, this.evalInterval, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "AlertConverge.AlertConvergeBuilder(id=" + this.id + ", name=" + this.name + ", enable=" + this.enable + ", matchAll=" + this.matchAll + ", priorities=" + this.priorities + ", tags=" + this.tags + ", evalInterval=" + this.evalInterval + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

