/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.alerter;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.hertzbeat.common.entity.alerter.JsonMapAttributeConverter;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_alert")
@Schema(description="Alarm record entity")
@EntityListeners(value={AuditingEntityListener.class})
public class Alert {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Alarm record entity primary key index ID", description="Alarm record entity primary key index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Alert target object: monitor availability-available metrics-app.metrics.field", description="Alert target object: monitor availability-available metrics-app.metrics.field", example="1", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=255)
    private @Size(max=255) String target;
    @Schema(title="Alarm definition ID associated with the alarm", description="Alarm definition ID associated with the alarm", example="8743267443543", accessMode=Schema.AccessMode.READ_WRITE)
    private Long alertDefineId;
    @Schema(title="Alarm level 0:High-Emergency-Critical Alarm 1:Medium-Critical-Critical Alarm 2:Low-Warning-Warning", example="1", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    @Max(value=2L)
    private @Min(value=0L) @Max(value=2L) byte priority;
    @Schema(title="The actual content of the alarm notification", description="The actual content of the alarm notification", example="linux_192.134.32.1: 534543534 cpu usage high", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(length=4096)
    private String content;
    @Schema(title="Alarm status: 0-normal alarm (to be processed) 1-threshold triggered but not reached the number of alarms 2-recovered alarm 3-processed", description="Alarm status: 0-normal alarm (to be processed) 1-threshold triggered but not reached the number of alarms 2-recovered alarm 3-processed", example="1", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    @Max(value=3L)
    private @Min(value=0L) @Max(value=3L) byte status;
    @Schema(title="Alarm times", description="Alarm times", example="3", accessMode=Schema.AccessMode.READ_WRITE)
    private Integer times;
    @Schema(title="Alarm trigger time (timestamp in milliseconds)", description="Alarm trigger time (timestamp in milliseconds)", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    private Long firstAlarmTime;
    @Schema(title="Alarm trigger time (timestamp in milliseconds)", description="Alarm trigger time (timestamp in milliseconds)", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    private Long lastAlarmTime;
    @Schema(title="Alarm threshold trigger times", description="Alarm threshold trigger times", example="3", accessMode=Schema.AccessMode.READ_WRITE)
    @Transient
    private Integer triggerTimes;
    @Schema(description="Alarm information label(monitorId:xxx,monitorName:xxx)", example="{key1:value1}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=2048)
    private Map<String, String> tags;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record the latest creation time (timestamp in milliseconds)", description="Record the latest creation time (timestamp in milliseconds)", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public Alert clone() {
        return JsonUtil.fromJson(JsonUtil.toJson(this), Alert.class);
    }

    public static AlertBuilder builder() {
        return new AlertBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getTarget() {
        return this.target;
    }

    public Long getAlertDefineId() {
        return this.alertDefineId;
    }

    public byte getPriority() {
        return this.priority;
    }

    public String getContent() {
        return this.content;
    }

    public byte getStatus() {
        return this.status;
    }

    public Integer getTimes() {
        return this.times;
    }

    public Long getFirstAlarmTime() {
        return this.firstAlarmTime;
    }

    public Long getLastAlarmTime() {
        return this.lastAlarmTime;
    }

    public Integer getTriggerTimes() {
        return this.triggerTimes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setAlertDefineId(Long alertDefineId) {
        this.alertDefineId = alertDefineId;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public void setTimes(Integer times) {
        this.times = times;
    }

    public void setFirstAlarmTime(Long firstAlarmTime) {
        this.firstAlarmTime = firstAlarmTime;
    }

    public void setLastAlarmTime(Long lastAlarmTime) {
        this.lastAlarmTime = lastAlarmTime;
    }

    public void setTriggerTimes(Integer triggerTimes) {
        this.triggerTimes = triggerTimes;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$alertDefineId = this.getAlertDefineId();
        Long other$alertDefineId = other.getAlertDefineId();
        if (this$alertDefineId == null ? other$alertDefineId != null : !((Object)this$alertDefineId).equals(other$alertDefineId)) {
            return false;
        }
        Integer this$times = this.getTimes();
        Integer other$times = other.getTimes();
        if (this$times == null ? other$times != null : !((Object)this$times).equals(other$times)) {
            return false;
        }
        Long this$firstAlarmTime = this.getFirstAlarmTime();
        Long other$firstAlarmTime = other.getFirstAlarmTime();
        if (this$firstAlarmTime == null ? other$firstAlarmTime != null : !((Object)this$firstAlarmTime).equals(other$firstAlarmTime)) {
            return false;
        }
        Long this$lastAlarmTime = this.getLastAlarmTime();
        Long other$lastAlarmTime = other.getLastAlarmTime();
        if (this$lastAlarmTime == null ? other$lastAlarmTime != null : !((Object)this$lastAlarmTime).equals(other$lastAlarmTime)) {
            return false;
        }
        Integer this$triggerTimes = this.getTriggerTimes();
        Integer other$triggerTimes = other.getTriggerTimes();
        if (this$triggerTimes == null ? other$triggerTimes != null : !((Object)this$triggerTimes).equals(other$triggerTimes)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Alert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        result = result * 59 + this.getStatus();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $alertDefineId = this.getAlertDefineId();
        result = result * 59 + ($alertDefineId == null ? 43 : ((Object)$alertDefineId).hashCode());
        Integer $times = this.getTimes();
        result = result * 59 + ($times == null ? 43 : ((Object)$times).hashCode());
        Long $firstAlarmTime = this.getFirstAlarmTime();
        result = result * 59 + ($firstAlarmTime == null ? 43 : ((Object)$firstAlarmTime).hashCode());
        Long $lastAlarmTime = this.getLastAlarmTime();
        result = result * 59 + ($lastAlarmTime == null ? 43 : ((Object)$lastAlarmTime).hashCode());
        Integer $triggerTimes = this.getTriggerTimes();
        result = result * 59 + ($triggerTimes == null ? 43 : ((Object)$triggerTimes).hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "Alert(id=" + this.getId() + ", target=" + this.getTarget() + ", alertDefineId=" + this.getAlertDefineId() + ", priority=" + this.getPriority() + ", content=" + this.getContent() + ", status=" + this.getStatus() + ", times=" + this.getTimes() + ", firstAlarmTime=" + this.getFirstAlarmTime() + ", lastAlarmTime=" + this.getLastAlarmTime() + ", triggerTimes=" + this.getTriggerTimes() + ", tags=" + this.getTags() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public Alert(Long id, String target, Long alertDefineId, byte priority, String content, byte status, Integer times, Long firstAlarmTime, Long lastAlarmTime, Integer triggerTimes, Map<String, String> tags, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.target = target;
        this.alertDefineId = alertDefineId;
        this.priority = priority;
        this.content = content;
        this.status = status;
        this.times = times;
        this.firstAlarmTime = firstAlarmTime;
        this.lastAlarmTime = lastAlarmTime;
        this.triggerTimes = triggerTimes;
        this.tags = tags;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public Alert() {
    }

    public static class AlertBuilder {
        private Long id;
        private String target;
        private Long alertDefineId;
        private byte priority;
        private String content;
        private byte status;
        private Integer times;
        private Long firstAlarmTime;
        private Long lastAlarmTime;
        private Integer triggerTimes;
        private Map<String, String> tags;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        AlertBuilder() {
        }

        public AlertBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AlertBuilder target(String target) {
            this.target = target;
            return this;
        }

        public AlertBuilder alertDefineId(Long alertDefineId) {
            this.alertDefineId = alertDefineId;
            return this;
        }

        public AlertBuilder priority(byte priority) {
            this.priority = priority;
            return this;
        }

        public AlertBuilder content(String content) {
            this.content = content;
            return this;
        }

        public AlertBuilder status(byte status) {
            this.status = status;
            return this;
        }

        public AlertBuilder times(Integer times) {
            this.times = times;
            return this;
        }

        public AlertBuilder firstAlarmTime(Long firstAlarmTime) {
            this.firstAlarmTime = firstAlarmTime;
            return this;
        }

        public AlertBuilder lastAlarmTime(Long lastAlarmTime) {
            this.lastAlarmTime = lastAlarmTime;
            return this;
        }

        public AlertBuilder triggerTimes(Integer triggerTimes) {
            this.triggerTimes = triggerTimes;
            return this;
        }

        public AlertBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public AlertBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AlertBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public AlertBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AlertBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public Alert build() {
            return new Alert(this.id, this.target, this.alertDefineId, this.priority, this.content, this.status, this.times, this.firstAlarmTime, this.lastAlarmTime, this.triggerTimes, this.tags, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "Alert.AlertBuilder(id=" + this.id + ", target=" + this.target + ", alertDefineId=" + this.alertDefineId + ", priority=" + this.priority + ", content=" + this.content + ", status=" + this.status + ", times=" + this.times + ", firstAlarmTime=" + this.firstAlarmTime + ", lastAlarmTime=" + this.lastAlarmTime + ", triggerTimes=" + this.triggerTimes + ", tags=" + this.tags + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

