/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hertzbeat.manager.service.impl.AbstractImExportServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Service
public class YamlImExportServiceImpl
extends AbstractImExportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(YamlImExportServiceImpl.class);
    public static final String TYPE = "YAML";
    public static final String FILE_SUFFIX = ".yaml";

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public String getFileName() {
        return this.fileNamePrefix() + FILE_SUFFIX;
    }

    @Override
    List<AbstractImExportServiceImpl.ExportMonitorDTO> parseImport(InputStream is) {
        Yaml yaml = new Yaml();
        return (List)yaml.load(is);
    }

    @Override
    void writeOs(List<AbstractImExportServiceImpl.ExportMonitorDTO> monitorList, OutputStream os) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setIndent(2);
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        yaml.dump(monitorList, new OutputStreamWriter(os, StandardCharsets.UTF_8));
    }
}

