/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Resource;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hertzbeat.common.support.event.SystemConfigChangeEvent;
import org.apache.hertzbeat.manager.dao.GeneralConfigDao;
import org.apache.hertzbeat.manager.pojo.dto.SystemConfig;
import org.apache.hertzbeat.manager.service.impl.AbstractGeneralConfigServiceImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class SystemGeneralConfigServiceImpl
extends AbstractGeneralConfigServiceImpl<SystemConfig> {
    private static final Integer LANG_REGION_LENGTH = 2;
    @Resource
    private ApplicationContext applicationContext;

    protected SystemGeneralConfigServiceImpl(GeneralConfigDao generalConfigDao, ObjectMapper objectMapper) {
        super(generalConfigDao, objectMapper);
    }

    @Override
    public void handler(SystemConfig systemConfig) {
        if (systemConfig != null) {
            String[] arr;
            if (systemConfig.getTimeZoneId() != null) {
                TimeZone.setDefault(TimeZone.getTimeZone(systemConfig.getTimeZoneId()));
            }
            if (systemConfig.getLocale() != null && (arr = systemConfig.getLocale().split("_")).length == LANG_REGION_LENGTH) {
                String language = arr[0];
                String country = arr[1];
                Locale.setDefault(new Locale(language, country));
            }
            this.applicationContext.publishEvent(new SystemConfigChangeEvent(this.applicationContext));
        }
    }

    @Override
    public String type() {
        return "system";
    }

    @Override
    protected TypeReference<SystemConfig> getTypeReference() {
        return new TypeReference<SystemConfig>(){

            @Override
            public Type getType() {
                return SystemConfig.class;
            }
        };
    }
}

