/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hertzbeat.alert.dao.AlertDefineBindDao;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.manager.Collector;
import org.apache.hertzbeat.common.entity.manager.CollectorMonitorBind;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.common.entity.manager.Tag;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.support.event.MonitorDeletedEvent;
import org.apache.hertzbeat.common.util.AesUtil;
import org.apache.hertzbeat.common.util.IntervalExpressionUtil;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.SnowFlakeIdGenerator;
import org.apache.hertzbeat.manager.dao.CollectorDao;
import org.apache.hertzbeat.manager.dao.CollectorMonitorBindDao;
import org.apache.hertzbeat.manager.dao.MonitorDao;
import org.apache.hertzbeat.manager.dao.ParamDao;
import org.apache.hertzbeat.manager.dao.TagMonitorBindDao;
import org.apache.hertzbeat.manager.pojo.dto.AppCount;
import org.apache.hertzbeat.manager.pojo.dto.MonitorDto;
import org.apache.hertzbeat.manager.scheduler.CollectJobScheduling;
import org.apache.hertzbeat.manager.service.AppService;
import org.apache.hertzbeat.manager.service.ImExportService;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.apache.hertzbeat.manager.service.TagService;
import org.apache.hertzbeat.manager.support.exception.MonitorDatabaseException;
import org.apache.hertzbeat.manager.support.exception.MonitorDetectException;
import org.apache.hertzbeat.manager.support.exception.MonitorMetricsException;
import org.apache.hertzbeat.warehouse.service.WarehouseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class MonitorServiceImpl
implements MonitorService {
    private static final Logger log = LoggerFactory.getLogger(MonitorServiceImpl.class);
    private static final Long MONITOR_ID_TMP = 1000000000L;
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final String BLANK = "";
    public static final String PATTERN_HTTP = "(?i)http://";
    public static final String PATTERN_HTTPS = "(?i)https://";
    @Autowired
    private AppService appService;
    @Autowired
    private TagService tagService;
    @Autowired
    private CollectJobScheduling collectJobScheduling;
    @Autowired
    private MonitorDao monitorDao;
    @Autowired
    private ParamDao paramDao;
    @Autowired
    private CollectorDao collectorDao;
    @Autowired
    private CollectorMonitorBindDao collectorMonitorBindDao;
    @Autowired
    private AlertDefineBindDao alertDefineBindDao;
    @Autowired
    private TagMonitorBindDao tagMonitorBindDao;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private WarehouseService warehouseService;
    private final Map<String, ImExportService> imExportServiceMap = new HashMap<String, ImExportService>();

    public MonitorServiceImpl(List<ImExportService> imExportServiceList) {
        imExportServiceList.forEach(it -> this.imExportServiceMap.put(it.type(), (ImExportService)it));
    }

    @Override
    @Transactional(readOnly=true)
    public void detectMonitor(Monitor monitor, List<Param> params, String collector) throws MonitorDetectException {
        Long monitorId = monitor.getId();
        if (monitorId == null || monitorId == 0L) {
            monitorId = MONITOR_ID_TMP;
        }
        Job appDefine = this.appService.getAppDefine(monitor.getApp());
        if ("prometheus".equals(monitor.getApp())) {
            appDefine.setApp("_prometheus_" + monitor.getName());
        }
        appDefine.setMonitorId(monitorId);
        appDefine.setCyclic(false);
        appDefine.setTimestamp(System.currentTimeMillis());
        List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
        appDefine.setConfigmap(configmaps);
        List<Metrics> availableMetrics = appDefine.getMetrics().stream().filter(item -> item.getPriority() == 0).collect(Collectors.toList());
        appDefine.setMetrics(availableMetrics);
        List<CollectRep.MetricsData> collectRep = collector != null ? this.collectJobScheduling.collectSyncJobData(appDefine, collector) : this.collectJobScheduling.collectSyncJobData(appDefine);
        if (collectRep == null || collectRep.isEmpty()) {
            throw new MonitorDetectException("Collect Timeout No Response");
        }
        if (collectRep.get(0).getCode() != CollectRep.Code.SUCCESS) {
            throw new MonitorDetectException(collectRep.get(0).getMsg());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addMonitor(Monitor monitor, List<Param> params, String collector) throws RuntimeException {
        long monitorId = SnowFlakeIdGenerator.generateId();
        List<Tag> tags = monitor.getTags();
        if (tags == null) {
            tags = new LinkedList<Tag>();
            monitor.setTags(tags);
        }
        tags.add(Tag.builder().name("monitorId").tagValue(String.valueOf(monitorId)).type((byte)0).build());
        tags.add(Tag.builder().name("monitorName").tagValue(String.valueOf(monitor.getName())).type((byte)0).build());
        Job appDefine = this.appService.getAppDefine(monitor.getApp());
        if ("prometheus".equals(monitor.getApp())) {
            appDefine.setApp("_prometheus_" + monitor.getName());
        }
        appDefine.setMonitorId(monitorId);
        appDefine.setInterval(monitor.getIntervals().intValue());
        appDefine.setCyclic(true);
        appDefine.setTimestamp(System.currentTimeMillis());
        List<Configmap> configmaps = params.stream().map(param -> {
            param.setMonitorId(monitorId);
            return new Configmap(param.getField(), param.getParamValue(), param.getType());
        }).collect(Collectors.toList());
        appDefine.setConfigmap(configmaps);
        long jobId = collector == null ? this.collectJobScheduling.addAsyncCollectJob(appDefine, null) : this.collectJobScheduling.addAsyncCollectJob(appDefine, collector);
        try {
            if (collector != null) {
                CollectorMonitorBind collectorMonitorBind = CollectorMonitorBind.builder().collector(collector).monitorId(monitorId).build();
                this.collectorMonitorBindDao.save(collectorMonitorBind);
            }
            monitor.setId(monitorId);
            monitor.setJobId(jobId);
            monitor.setStatus((byte)1);
            this.monitorDao.save(monitor);
            this.paramDao.saveAll(params);
        }
        catch (Exception e) {
            log.error("Error while adding monitor: {}", (Object)e.getMessage(), (Object)e);
            this.collectJobScheduling.cancelAsyncCollectJob(jobId);
            throw new MonitorDatabaseException(e.getMessage());
        }
    }

    @Override
    public void addNewMonitorOptionalMetrics(List<String> metrics, Monitor monitor, List<Param> params) {
        long monitorId = SnowFlakeIdGenerator.generateId();
        List<Tag> tags = monitor.getTags();
        if (tags == null) {
            tags = new LinkedList<Tag>();
            monitor.setTags(tags);
        }
        tags.add(Tag.builder().name("monitorId").tagValue(String.valueOf(monitorId)).type((byte)0).build());
        tags.add(Tag.builder().name("monitorName").tagValue(String.valueOf(monitor.getName())).type((byte)0).build());
        Job appDefine = this.appService.getAppDefine(monitor.getApp());
        List<Metrics> metricsDefine = appDefine.getMetrics();
        Set metricsDefineNamesSet = metricsDefine.stream().map(Metrics::getName).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(metrics) || !metricsDefineNamesSet.containsAll(metrics)) {
            throw new MonitorMetricsException("no select metrics or select illegal metrics");
        }
        List<Metrics> realMetrics = metricsDefine.stream().filter(m -> metrics.contains(m.getName())).collect(Collectors.toList());
        appDefine.setMetrics(realMetrics);
        appDefine.setMonitorId(monitorId);
        appDefine.setInterval(monitor.getIntervals().intValue());
        appDefine.setCyclic(true);
        appDefine.setTimestamp(System.currentTimeMillis());
        List<Configmap> configmaps = params.stream().map(param -> {
            param.setMonitorId(monitorId);
            return new Configmap(param.getField(), param.getParamValue(), param.getType());
        }).collect(Collectors.toList());
        appDefine.setConfigmap(configmaps);
        long jobId = this.collectJobScheduling.addAsyncCollectJob(appDefine, null);
        try {
            monitor.setId(monitorId);
            monitor.setJobId(jobId);
            monitor.setStatus((byte)1);
            this.monitorDao.save(monitor);
            this.paramDao.saveAll(params);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            this.collectJobScheduling.cancelAsyncCollectJob(jobId);
            throw new MonitorDatabaseException(e.getMessage());
        }
    }

    @Override
    public List<String> getMonitorMetrics(String app) {
        return this.appService.getAppDefineMetricNames(app);
    }

    @Override
    public void export(List<Long> ids, String type, HttpServletResponse res) throws Exception {
        ImExportService imExportService = this.imExportServiceMap.get(type);
        if (imExportService == null) {
            throw new IllegalArgumentException("not support export type: " + type);
        }
        String fileName = imExportService.getFileName();
        res.setHeader("content-type", "application/octet-stream;charset=UTF-8");
        res.setContentType("application/octet-stream;charset=UTF-8");
        res.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, StandardCharsets.UTF_8));
        res.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        imExportService.exportConfig(res.getOutputStream(), ids);
    }

    @Override
    public void importConfig(MultipartFile file) throws Exception {
        String fileName = file.getOriginalFilename();
        if (!StringUtils.hasText(fileName)) {
            return;
        }
        String type = BLANK;
        if (fileName.toLowerCase().endsWith(".json")) {
            type = "JSON";
        }
        if (fileName.toLowerCase().endsWith(".xlsx")) {
            type = "EXCEL";
        }
        if (fileName.toLowerCase().endsWith(".yaml")) {
            type = "YAML";
        }
        if (!this.imExportServiceMap.containsKey(type)) {
            throw new RuntimeException("file " + fileName + " is not supported.");
        }
        ImExportService imExportService = this.imExportServiceMap.get(type);
        imExportService.importConfig(file.getInputStream());
    }

    @Override
    @Transactional(readOnly=true)
    public void validate(MonitorDto monitorDto, Boolean isModify) throws IllegalArgumentException {
        Monitor monitor = monitorDto.getMonitor();
        monitor.setHost(monitor.getHost().trim());
        monitor.setName(monitor.getName().trim());
        Map<String, Param> paramMap = monitorDto.getParams().stream().peek(param -> {
            param.setMonitorId(monitor.getId());
            String value = param.getParamValue() == null ? null : param.getParamValue().trim();
            param.setParamValue(value);
        }).collect(Collectors.toMap(Param::getField, param -> param));
        if (isModify != null) {
            Optional<Job> defineOptional = this.appService.getAppDefineOption(monitor.getName());
            if (defineOptional.isPresent()) {
                throw new IllegalArgumentException("Monitoring name cannot be the existed monitoring type name!");
            }
            Optional<Monitor> monitorOptional = this.monitorDao.findMonitorByNameEquals(monitor.getName());
            if (monitorOptional.isPresent()) {
                Monitor existMonitor = monitorOptional.get();
                if (isModify.booleanValue()) {
                    if (!existMonitor.getId().equals(monitor.getId())) {
                        throw new IllegalArgumentException("Monitoring name already exists!");
                    }
                } else {
                    throw new IllegalArgumentException("Monitoring name already exists!");
                }
            }
        }
        if (monitor.getTags() != null) {
            monitor.setTags(monitor.getTags().stream().distinct().collect(Collectors.toList()));
        }
        if (StringUtils.hasText(monitorDto.getCollector())) {
            Optional<Collector> optionalCollector = this.collectorDao.findCollectorByName(monitorDto.getCollector());
            if (optionalCollector.isEmpty()) {
                throw new IllegalArgumentException("The pinned collector does not exist.");
            }
        } else {
            monitorDto.setCollector(null);
        }
        List<ParamDefine> paramDefines = this.appService.getAppParamDefines(monitorDto.getMonitor().getApp());
        if (paramDefines != null) {
            block27: for (ParamDefine paramDefine : paramDefines) {
                String field = paramDefine.getField();
                Param param2 = paramMap.get(field);
                if (paramDefine.isRequired() && (param2 == null || param2.getParamValue() == null)) {
                    throw new IllegalArgumentException("Params field " + field + " is required.");
                }
                if (param2 == null || param2.getParamValue() == null || BLANK.equals(param2.getParamValue())) continue;
                switch (paramDefine.getType()) {
                    case "number": {
                        double doubleValue;
                        try {
                            doubleValue = Double.parseDouble(param2.getParamValue());
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Params field " + field + " type " + paramDefine.getType() + " is invalid.");
                        }
                        if (paramDefine.getRange() != null && !IntervalExpressionUtil.validNumberIntervalExpress(doubleValue, paramDefine.getRange())) {
                            throw new IllegalArgumentException("Params field " + field + " type " + paramDefine.getType() + " over range " + paramDefine.getRange());
                        }
                        param2.setType((byte)0);
                        continue block27;
                    }
                    case "textarea": {
                        Short textareaLimit = paramDefine.getLimit();
                        if (textareaLimit == null || param2.getParamValue().length() <= textareaLimit) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " type " + paramDefine.getType() + " over limit " + param2.getParamValue());
                    }
                    case "text": {
                        Short textLimit = paramDefine.getLimit();
                        if (textLimit == null || param2.getParamValue().length() <= textLimit) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " type " + paramDefine.getType() + " over limit " + textLimit);
                    }
                    case "host": {
                        String hostValue = param2.getParamValue();
                        if (hostValue.toLowerCase().contains(HTTP)) {
                            hostValue = hostValue.replaceAll(PATTERN_HTTP, BLANK);
                        }
                        if (hostValue.toLowerCase().contains(HTTPS)) {
                            hostValue = hostValue.replace(PATTERN_HTTPS, BLANK);
                        }
                        if (IpDomainUtil.validateIpDomain(hostValue)) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " value " + hostValue + " is invalid host value.");
                    }
                    case "password": {
                        String passwordValue = param2.getParamValue();
                        if (!AesUtil.isCiphertext(passwordValue)) {
                            passwordValue = AesUtil.aesEncode(passwordValue);
                            param2.setParamValue(passwordValue);
                        }
                        param2.setType((byte)2);
                        continue block27;
                    }
                    case "boolean": {
                        String booleanValue = param2.getParamValue();
                        if ("true".equalsIgnoreCase(booleanValue) || "false".equalsIgnoreCase(booleanValue)) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " value " + booleanValue + " is invalid boolean value.");
                    }
                    case "radio": {
                        List<ParamDefine.Option> options = paramDefine.getOptions();
                        boolean invalid = true;
                        if (options != null) {
                            for (ParamDefine.Option option : options) {
                                if (!param2.getParamValue().equalsIgnoreCase(option.getValue())) continue;
                                invalid = false;
                                break;
                            }
                        }
                        if (!invalid) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " value " + param2.getParamValue() + " is invalid option value");
                    }
                    case "checkbox": {
                        List<ParamDefine.Option> checkboxOptions = paramDefine.getOptions();
                        boolean checkboxInvalid = true;
                        if (checkboxOptions != null) {
                            for (ParamDefine.Option option : checkboxOptions) {
                                if (!param2.getParamValue().equalsIgnoreCase(option.getValue())) continue;
                                checkboxInvalid = false;
                                break;
                            }
                        }
                        if (!checkboxInvalid) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " value " + param2.getParamValue() + " is invalid checkbox value");
                    }
                    case "metrics-field": 
                    case "key-value": {
                        if (JsonUtil.fromJson(param2.getParamValue(), new TypeReference<Object>(){}) != null) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " value " + param2.getParamValue() + " is invalid key-value value");
                    }
                    case "array": {
                        String[] arrays = param2.getParamValue().split(",");
                        if (arrays.length == 0) {
                            throw new IllegalArgumentException("Param field" + field + " value " + param2.getParamValue() + " is invalid arrays value");
                        }
                        if (!param2.getParamValue().startsWith("[") || !param2.getParamValue().endsWith("]")) continue block27;
                        param2.setParamValue(param2.getParamValue().substring(1, param2.getParamValue().length() - 1));
                        continue block27;
                    }
                }
                throw new IllegalArgumentException("ParamDefine type " + paramDefine.getType() + " is invalid.");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyMonitor(Monitor monitor, List<Param> params, String collector) throws RuntimeException {
        long monitorId = monitor.getId();
        Optional queryOption = this.monitorDao.findById(monitorId);
        if (queryOption.isEmpty()) {
            throw new IllegalArgumentException("The Monitor " + monitorId + " not exists");
        }
        Monitor preMonitor = (Monitor)queryOption.get();
        if (!preMonitor.getApp().equals(monitor.getApp())) {
            throw new IllegalArgumentException("Can not modify monitor's app type");
        }
        List<Tag> tags = monitor.getTags();
        if (tags == null) {
            tags = new LinkedList<Tag>();
            monitor.setTags(tags);
        }
        for (Tag tag : tags) {
            if (!"monitorName".equals(tag.getName())) continue;
            tag.setTagValue(monitor.getName());
        }
        if (preMonitor.getStatus() != 0) {
            Job appDefine = this.appService.getAppDefine(monitor.getApp());
            if ("prometheus".equals(monitor.getApp())) {
                appDefine.setApp("_prometheus_" + monitor.getName());
            }
            appDefine.setId(preMonitor.getJobId());
            appDefine.setMonitorId(monitorId);
            appDefine.setInterval(monitor.getIntervals().intValue());
            appDefine.setCyclic(true);
            appDefine.setTimestamp(System.currentTimeMillis());
            if (params != null) {
                List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
                appDefine.setConfigmap(configmaps);
            }
            long newJobId = collector == null ? this.collectJobScheduling.updateAsyncCollectJob(appDefine) : this.collectJobScheduling.updateAsyncCollectJob(appDefine, collector);
            monitor.setJobId(newJobId);
        }
        try {
            this.collectorMonitorBindDao.deleteCollectorMonitorBindsByMonitorId(monitorId);
            if (collector != null) {
                CollectorMonitorBind collectorMonitorBind = CollectorMonitorBind.builder().collector(collector).monitorId(monitorId).build();
                this.collectorMonitorBindDao.save(collectorMonitorBind);
            }
            monitor.setStatus(preMonitor.getStatus());
            monitor.setGmtUpdate(LocalDateTime.now());
            this.monitorDao.save(monitor);
            if (params != null) {
                this.paramDao.saveAll(params);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            this.collectJobScheduling.cancelAsyncCollectJob(monitor.getJobId());
            throw new MonitorDatabaseException(e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteMonitor(long id) throws RuntimeException {
        Optional monitorOptional = this.monitorDao.findById(id);
        if (monitorOptional.isPresent()) {
            Monitor monitor = (Monitor)monitorOptional.get();
            this.monitorDao.deleteById(id);
            this.tagService.deleteMonitorSystemTags(monitor);
            this.paramDao.deleteParamsByMonitorId(id);
            this.tagMonitorBindDao.deleteTagMonitorBindsByMonitorId(id);
            this.alertDefineBindDao.deleteAlertDefineMonitorBindsByMonitorIdEquals(id);
            this.collectorMonitorBindDao.deleteCollectorMonitorBindsByMonitorId(id);
            this.collectJobScheduling.cancelAsyncCollectJob(monitor.getJobId());
            this.applicationContext.publishEvent(new MonitorDeletedEvent((Object)this.applicationContext, monitor.getId()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteMonitors(Set<Long> ids) throws RuntimeException {
        List<Monitor> monitors = this.monitorDao.findMonitorsByIdIn(ids);
        if (!monitors.isEmpty()) {
            this.monitorDao.deleteAll(monitors);
            this.paramDao.deleteParamsByMonitorIdIn(ids);
            Set<Long> monitorIds = monitors.stream().map(Monitor::getId).collect(Collectors.toSet());
            this.tagMonitorBindDao.deleteTagMonitorBindsByMonitorIdIn(monitorIds);
            this.alertDefineBindDao.deleteAlertDefineMonitorBindsByMonitorIdIn(monitorIds);
            for (Monitor monitor : monitors) {
                this.tagService.deleteMonitorSystemTags(monitor);
                this.collectorMonitorBindDao.deleteCollectorMonitorBindsByMonitorId(monitor.getId());
                this.collectJobScheduling.cancelAsyncCollectJob(monitor.getJobId());
                this.applicationContext.publishEvent(new MonitorDeletedEvent((Object)this.applicationContext, monitor.getId()));
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public MonitorDto getMonitorDto(long id) throws RuntimeException {
        Optional monitorOptional = this.monitorDao.findById(id);
        if (monitorOptional.isPresent()) {
            Monitor monitor = (Monitor)monitorOptional.get();
            MonitorDto monitorDto = new MonitorDto();
            monitorDto.setMonitor(monitor);
            List<Param> params = this.paramDao.findParamsByMonitorId(id);
            monitorDto.setParams(params);
            if ("prometheus".equalsIgnoreCase(monitor.getApp())) {
                List<CollectRep.MetricsData> metricsDataList = this.warehouseService.queryMonitorMetricsData(id);
                List<String> metrics = metricsDataList.stream().map(CollectRep.MetricsData::getMetrics).collect(Collectors.toList());
                monitorDto.setMetrics(metrics);
            } else {
                Job job = this.appService.getAppDefine(monitor.getApp());
                List<String> metrics = job.getMetrics().stream().filter(Metrics::isVisible).map(Metrics::getName).collect(Collectors.toList());
                monitorDto.setMetrics(metrics);
            }
            Optional<CollectorMonitorBind> bindOptional = this.collectorMonitorBindDao.findCollectorMonitorBindByMonitorId(monitor.getId());
            bindOptional.ifPresent(bind -> monitorDto.setCollector(bind.getCollector()));
            return monitorDto;
        }
        return null;
    }

    @Override
    public Page<Monitor> getMonitors(Specification<Monitor> specification, PageRequest pageRequest) {
        return this.monitorDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void cancelManageMonitors(HashSet<Long> ids) {
        List managedMonitors = this.monitorDao.findMonitorsByIdIn(ids).stream().filter(monitor -> monitor.getStatus() != 0).peek(monitor -> monitor.setStatus((byte)0)).collect(Collectors.toList());
        if (!managedMonitors.isEmpty()) {
            for (Monitor monitor2 : managedMonitors) {
                this.collectJobScheduling.cancelAsyncCollectJob(monitor2.getJobId());
            }
            this.monitorDao.saveAll((Iterable)managedMonitors);
        }
    }

    @Override
    public void enableManageMonitors(HashSet<Long> ids) {
        List unManagedMonitors = this.monitorDao.findMonitorsByIdIn(ids).stream().filter(monitor -> monitor.getStatus() == 0).peek(monitor -> monitor.setStatus((byte)1)).collect(Collectors.toList());
        if (!unManagedMonitors.isEmpty()) {
            for (Monitor monitor2 : unManagedMonitors) {
                Job appDefine = this.appService.getAppDefine(monitor2.getApp());
                if ("prometheus".equals(monitor2.getApp())) {
                    appDefine.setApp("_prometheus_" + monitor2.getName());
                }
                appDefine.setMonitorId(monitor2.getId());
                appDefine.setInterval(monitor2.getIntervals().intValue());
                appDefine.setCyclic(true);
                appDefine.setTimestamp(System.currentTimeMillis());
                List<Param> params = this.paramDao.findParamsByMonitorId(monitor2.getId());
                List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
                List<ParamDefine> paramDefaultValue = appDefine.getParams().stream().filter(item -> StringUtils.hasText(item.getDefaultValue())).collect(Collectors.toList());
                paramDefaultValue.forEach(defaultVar -> {
                    if (configmaps.stream().noneMatch(item -> item.getKey().equals(defaultVar.getField()))) {
                        Configmap configmap = new Configmap(defaultVar.getField(), defaultVar.getDefaultValue(), 1);
                        configmaps.add(configmap);
                    }
                });
                appDefine.setConfigmap(configmaps);
                Optional<CollectorMonitorBind> bindOptional = this.collectorMonitorBindDao.findCollectorMonitorBindByMonitorId(monitor2.getId());
                long newJobId = bindOptional.map(bind -> this.collectJobScheduling.addAsyncCollectJob(appDefine, bind.getCollector())).orElseGet(() -> this.collectJobScheduling.addAsyncCollectJob(appDefine, null));
                monitor2.setJobId(newJobId);
                this.applicationContext.publishEvent(new MonitorDeletedEvent((Object)this.applicationContext, monitor2.getId()));
            }
            this.monitorDao.saveAll((Iterable)unManagedMonitors);
        }
    }

    @Override
    public List<AppCount> getAllAppMonitorsCount() {
        List<AppCount> appCounts = this.monitorDao.findAppsStatusCount();
        if (appCounts == null) {
            return null;
        }
        HashMap<String, AppCount> appCountMap = new HashMap<String, AppCount>(appCounts.size());
        for (AppCount item2 : appCounts) {
            AppCount appCount = appCountMap.getOrDefault(item2.getApp(), new AppCount());
            appCount.setApp(item2.getApp());
            switch (item2.getStatus()) {
                case 1: {
                    appCount.setAvailableSize(appCount.getAvailableSize() + item2.getSize());
                    break;
                }
                case 2: {
                    appCount.setUnAvailableSize(appCount.getUnAvailableSize() + item2.getSize());
                    break;
                }
                case 0: {
                    appCount.setUnManageSize(appCount.getUnManageSize() + item2.getSize());
                    break;
                }
            }
            appCountMap.put(item2.getApp(), appCount);
        }
        return appCountMap.values().stream().map(item -> {
            item.setSize(item.getAvailableSize() + item.getUnManageSize() + item.getUnAvailableSize());
            try {
                Job job = this.appService.getAppDefine(item.getApp());
                item.setCategory(job.getCategory());
            }
            catch (Exception ignored) {
                return null;
            }
            return item;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyMonitors(List<Long> ids) {
        ((Stream)ids.stream().parallel()).forEach(id -> {
            Optional<Monitor> monitorOpt = this.monitorDao.findById(id);
            List<Param> params = this.paramDao.findParamsByMonitorId((Long)id);
            monitorOpt.ifPresentOrElse(monitor -> {
                Monitor newMonitor = JsonUtil.fromJson(JsonUtil.toJson(monitor), Monitor.class);
                if (newMonitor != null) {
                    this.copyMonitor(newMonitor, params);
                }
            }, () -> log.warn("can not find the monitor for id \uff1a{}", id));
        });
    }

    @Override
    public void updateAppCollectJob(Job job) {
        List<Monitor> monitors = this.monitorDao.findMonitorsByAppEquals(job.getApp()).stream().filter(monitor -> monitor.getStatus() != 0).toList();
        if (monitors.isEmpty()) {
            return;
        }
        List<CollectorMonitorBind> monitorBinds = this.collectorMonitorBindDao.findCollectorMonitorBindsByMonitorIdIn(monitors.stream().map(Monitor::getId).collect(Collectors.toSet()));
        Map<Long, String> monitorIdCollectorMap = monitorBinds.stream().collect(Collectors.toMap(CollectorMonitorBind::getMonitorId, CollectorMonitorBind::getCollector));
        for (Monitor monitor2 : monitors) {
            try {
                Job appDefine = job.clone();
                if (monitor2 == null || appDefine == null || monitor2.getId() == null || monitor2.getJobId() == null) {
                    log.error("update monitor job error when template modify, define | id | jobId is null. continue");
                    continue;
                }
                if ("prometheus".equals(monitor2.getApp())) {
                    appDefine.setApp("_prometheus_" + monitor2.getName());
                }
                appDefine.setId(monitor2.getJobId());
                appDefine.setMonitorId(monitor2.getId());
                appDefine.setInterval(monitor2.getIntervals().intValue());
                appDefine.setCyclic(true);
                appDefine.setTimestamp(System.currentTimeMillis());
                List<Param> params = this.paramDao.findParamsByMonitorId(monitor2.getId());
                List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
                List<ParamDefine> paramDefaultValue = appDefine.getParams().stream().filter(item -> StringUtils.hasText(item.getDefaultValue())).toList();
                paramDefaultValue.forEach(defaultVar -> {
                    if (configmaps.stream().noneMatch(item -> item.getKey().equals(defaultVar.getField()))) {
                        Configmap configmap = new Configmap(defaultVar.getField(), defaultVar.getDefaultValue(), 1);
                        configmaps.add(configmap);
                    }
                });
                appDefine.setConfigmap(configmaps);
                String collector = monitorIdCollectorMap.get(monitor2.getId());
                long newJobId = this.collectJobScheduling.updateAsyncCollectJob(appDefine, collector);
                monitor2.setJobId(newJobId);
                this.monitorDao.save(monitor2);
            }
            catch (Exception e) {
                log.error("update monitor job error when template modify: {}.continue", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Override
    public Monitor getMonitor(Long monitorId) {
        return this.monitorDao.findById(monitorId).orElse(null);
    }

    @Override
    public void updateMonitorStatus(Long monitorId, byte status) {
        this.monitorDao.updateMonitorStatus(monitorId, status);
    }

    @Override
    public List<Monitor> getAppMonitors(String app) {
        return this.monitorDao.findMonitorsByAppEquals(app);
    }

    private void copyMonitor(Monitor monitor, List<Param> params) {
        List<Tag> oldTags = monitor.getTags();
        List<Tag> newTags = this.filterTags(oldTags);
        monitor.setTags(newTags);
        monitor.setName(String.format("%s - copy", monitor.getName()));
        this.addMonitor(monitor, params, null);
    }

    private List<Tag> filterTags(List<Tag> tags) {
        if (tags == null || tags.isEmpty()) {
            return new LinkedList<Tag>();
        }
        return tags.stream().filter(tag -> !tag.getName().equals("monitorId") && !tag.getName().equals("monitorName")).collect(Collectors.toList());
    }
}

