/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.hertzbeat.manager.service.impl.AbstractImExportServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JsonImExportServiceImpl
extends AbstractImExportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(JsonImExportServiceImpl.class);
    public static final String TYPE = "JSON";
    public static final String FILE_SUFFIX = ".json";
    private final ObjectMapper objectMapper;

    @Override
    List<AbstractImExportServiceImpl.ExportMonitorDTO> parseImport(InputStream is) {
        try {
            return this.objectMapper.readValue(is, new TypeReference<List<AbstractImExportServiceImpl.ExportMonitorDTO>>(){});
        }
        catch (IOException ex) {
            log.error("import monitor failed.", ex);
            throw new RuntimeException("import monitor failed");
        }
    }

    @Override
    void writeOs(List<AbstractImExportServiceImpl.ExportMonitorDTO> monitorList, OutputStream os) {
        try {
            this.objectMapper.writeValue(os, monitorList);
        }
        catch (IOException ex) {
            log.error("export monitor failed.", ex);
            throw new RuntimeException("export monitor failed");
        }
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public String getFileName() {
        return this.fileNamePrefix() + FILE_SUFFIX;
    }

    public JsonImExportServiceImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

