/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.CollectorSummary;
import org.apache.hertzbeat.common.entity.manager.Collector;
import org.apache.hertzbeat.common.entity.manager.CollectorMonitorBind;
import org.apache.hertzbeat.common.support.exception.CommonException;
import org.apache.hertzbeat.manager.dao.CollectorDao;
import org.apache.hertzbeat.manager.dao.CollectorMonitorBindDao;
import org.apache.hertzbeat.manager.scheduler.AssignJobs;
import org.apache.hertzbeat.manager.scheduler.ConsistentHash;
import org.apache.hertzbeat.manager.scheduler.netty.ManageServer;
import org.apache.hertzbeat.manager.service.CollectorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CollectorServiceImpl
implements CollectorService {
    @Autowired
    private CollectorDao collectorDao;
    @Autowired
    private CollectorMonitorBindDao collectorMonitorBindDao;
    @Autowired
    private ConsistentHash consistentHash;
    @Autowired(required=false)
    private ManageServer manageServer;

    @Override
    @Transactional(readOnly=true)
    public Page<CollectorSummary> getCollectors(Specification<Collector> specification, PageRequest pageRequest) {
        Page<Collector> collectors = this.collectorDao.findAll(specification, (Pageable)pageRequest);
        LinkedList<CollectorSummary> collectorSummaryList = new LinkedList<CollectorSummary>();
        for (Collector collector : collectors.getContent()) {
            CollectorSummary.CollectorSummaryBuilder summaryBuilder = CollectorSummary.builder().collector(collector);
            ConsistentHash.Node node = this.consistentHash.getNode(collector.getName());
            if (node != null && node.getAssignJobs() != null) {
                AssignJobs assignJobs = node.getAssignJobs();
                summaryBuilder.pinMonitorNum(assignJobs.getPinnedJobs().size());
                summaryBuilder.dispatchMonitorNum(assignJobs.getJobs().size());
            }
            collectorSummaryList.add(summaryBuilder.build());
        }
        return new PageImpl<CollectorSummary>(collectorSummaryList, pageRequest, collectors.getTotalElements());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRegisteredCollector(List<String> collectors) {
        if (collectors == null || collectors.isEmpty()) {
            return;
        }
        collectors.forEach(collector -> {
            List<CollectorMonitorBind> binds = this.collectorMonitorBindDao.findCollectorMonitorBindsByCollector((String)collector);
            if (!binds.isEmpty()) {
                throw new CommonException("The collector " + collector + " has pinned tasks that cannot be deleted.");
            }
        });
        collectors.forEach(collector -> {
            this.manageServer.closeChannel((String)collector);
            this.collectorDao.deleteCollectorByName((String)collector);
        });
    }

    @Override
    public boolean hasCollector(String collector) {
        return this.collectorDao.findCollectorByName(collector).isPresent();
    }
}

