/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20210111.models.SendStatus;
import org.apache.hertzbeat.common.config.CommonProperties;
import org.apache.hertzbeat.common.support.exception.SendMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"common.sms.tencent.app-id"})
public class TencentSmsClient {
    private static final Logger log = LoggerFactory.getLogger(TencentSmsClient.class);
    private static final String RESPONSE_OK = "Ok";
    private static final String REGION = "ap-guangzhou";
    private SmsClient smsClient;
    private String appId;
    private String signName;
    private String templateId;

    public TencentSmsClient(CommonProperties properties) {
        if (properties == null || properties.getSms() == null || properties.getSms().getTencent() == null) {
            log.error("init error, please config TencentSmsClient props in application.yml");
            throw new IllegalArgumentException("please config TencentSmsClient props");
        }
        this.initSmsClient(properties.getSms().getTencent());
    }

    private void initSmsClient(CommonProperties.TencentSmsProperties tencent) {
        this.appId = tencent.getAppId();
        this.signName = tencent.getSignName();
        this.templateId = tencent.getTemplateId();
        Credential cred = new Credential(tencent.getSecretId(), tencent.getSecretKey());
        this.smsClient = new SmsClient(cred, REGION);
    }

    public void sendMessage(String appId, String signName, String templateId, String[] templateValues, String[] phones) {
        SendSmsRequest req = new SendSmsRequest();
        req.setSmsSdkAppId(appId);
        req.setSignName(signName);
        req.setTemplateId(templateId);
        req.setTemplateParamSet(templateValues);
        req.setPhoneNumberSet(phones);
        try {
            SendSmsResponse smsResponse = this.smsClient.SendSms(req);
            SendStatus sendStatus = smsResponse.getSendStatusSet()[0];
            if (!RESPONSE_OK.equals(sendStatus.getCode())) {
                throw new SendMessageException(sendStatus.getCode() + ":" + sendStatus.getMessage());
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            throw new SendMessageException(e.getMessage());
        }
    }

    public void sendMessage(String[] templateValues, String[] phones) {
        this.sendMessage(this.appId, this.signName, this.templateId, templateValues, phones);
    }
}

