/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.scheduler;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentTreeMap<K, V>
extends TreeMap<K, V> {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.readWriteLock.writeLock().lock();
        try {
            V v = super.put(key, value);
            return v;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public V remove(Object key) {
        this.readWriteLock.writeLock().lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        this.readWriteLock.readLock().lock();
        try {
            Map.Entry entry = super.firstEntry();
            return entry;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        this.readWriteLock.readLock().lock();
        try {
            Map.Entry entry = super.higherEntry(key);
            return entry;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        this.readWriteLock.readLock().lock();
        try {
            Map.Entry entry = super.ceilingEntry(key);
            return entry;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<K, V> ceilingOrFirstEntry(K key) {
        this.readWriteLock.readLock().lock();
        try {
            Map.Entry entry = super.ceilingEntry(key);
            if (entry == null) {
                Map.Entry entry2 = super.firstEntry();
                return entry2;
            }
            Map.Entry entry3 = entry;
            return entry3;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

