/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.manager.pojo.dto.MonitorDto;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Monitor Manage API")
@RestController
@RequestMapping(path={"/api/monitor"}, produces={"application/json"})
public class MonitorController {
    @Autowired
    private MonitorService monitorService;

    @PostMapping
    @Operation(summary="Add a monitoring application", description="Add a monitoring application")
    public ResponseEntity<Message<Void>> addNewMonitor(@Valid @RequestBody MonitorDto monitorDto) {
        this.monitorService.validate(monitorDto, false);
        if (monitorDto.isDetected()) {
            this.monitorService.detectMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector());
        }
        this.monitorService.addMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector());
        return ResponseEntity.ok(Message.success("Add success"));
    }

    @PutMapping
    @Operation(summary="Modify an existing monitoring application", description="Modify an existing monitoring application")
    public ResponseEntity<Message<Void>> modifyMonitor(@Valid @RequestBody MonitorDto monitorDto) {
        this.monitorService.validate(monitorDto, true);
        if (monitorDto.isDetected()) {
            this.monitorService.detectMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector());
        }
        this.monitorService.modifyMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector());
        return ResponseEntity.ok(Message.success("Modify success"));
    }

    @GetMapping(path={"/{id}"})
    @Operation(summary="Obtain monitoring information based on monitoring ID", description="Obtain monitoring information based on monitoring ID")
    public ResponseEntity<Message<MonitorDto>> getMonitor(@Parameter(description="Monitoring task ID", example="6565463543") @PathVariable(value="id") long id) {
        MonitorDto monitorDto = this.monitorService.getMonitorDto(id);
        if (monitorDto == null) {
            return ResponseEntity.ok(Message.fail((byte)3, "Monitor not exist."));
        }
        return ResponseEntity.ok(Message.success(monitorDto));
    }

    @DeleteMapping(path={"/{id}"})
    @Operation(summary="Delete monitoring application based on monitoring ID", description="Delete monitoring application based on monitoring ID")
    public ResponseEntity<Message<Void>> deleteMonitor(@Parameter(description="en: Monitor ID", example="6565463543") @PathVariable(value="id") long id) {
        Monitor monitor = this.monitorService.getMonitor(id);
        if (monitor == null) {
            return ResponseEntity.ok(Message.success("The specified monitoring was not queried, please check whether the parameters are correct"));
        }
        this.monitorService.deleteMonitor(id);
        return ResponseEntity.ok(Message.success("Delete success"));
    }

    @PostMapping(path={"/detect"})
    @Operation(summary="Perform availability detection on this monitoring based on monitoring information", description="Perform availability detection on this monitoring based on monitoring information")
    public ResponseEntity<Message<Void>> detectMonitor(@Valid @RequestBody MonitorDto monitorDto) {
        this.monitorService.validate(monitorDto, null);
        this.monitorService.detectMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector());
        return ResponseEntity.ok(Message.success("Detect success."));
    }

    @PostMapping(value={"/optional"})
    @Operation(summary="Add a monitor that can select metrics", description="Add a monitor that can select metrics")
    public ResponseEntity<Message<Void>> addNewMonitorOptionalMetrics(@Valid @RequestBody MonitorDto monitorDto) {
        this.monitorService.validate(monitorDto, false);
        if (monitorDto.isDetected()) {
            this.monitorService.detectMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector());
        }
        this.monitorService.addNewMonitorOptionalMetrics(monitorDto.getMetrics(), monitorDto.getMonitor(), monitorDto.getParams());
        return ResponseEntity.ok(Message.success("Add success"));
    }

    @GetMapping(value={"/metric/{app}", "/metric"})
    @Operation(summary="get app metric", description="Obtain indicators that can be monitored by the app based on the app name")
    public ResponseEntity<Message<List<String>>> getMonitorMetrics(@PathVariable(value="app", required=false) String app) {
        List<String> metricNames = this.monitorService.getMonitorMetrics(app);
        return ResponseEntity.ok(Message.success(metricNames));
    }
}

