/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.manager.pojo.dto.TemplateConfig;
import org.apache.hertzbeat.manager.service.GeneralConfigService;
import org.apache.hertzbeat.manager.service.impl.TemplateConfigServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/config"}, produces={"application/json"})
@Tag(name="Alert sender Configuration API")
public class GeneralConfigController {
    private static final Logger log = LoggerFactory.getLogger(GeneralConfigController.class);
    private Map<String, GeneralConfigService> configServiceMap = new HashMap<String, GeneralConfigService>(8);

    public GeneralConfigController(List<GeneralConfigService> generalConfigServices) {
        if (generalConfigServices != null) {
            generalConfigServices.forEach(config -> this.configServiceMap.put(config.type(), (GeneralConfigService)config));
        }
    }

    @PostMapping(path={"/{type}"})
    @Operation(summary="Save or update common config", description="Save or update common config")
    public ResponseEntity<Message<String>> saveOrUpdateConfig(@Parameter(description="Config Type", example="email") @PathVariable(value="type") @NotNull String type, @RequestBody Object config) {
        GeneralConfigService configService = this.configServiceMap.get(type);
        if (configService == null) {
            throw new IllegalArgumentException("Not supported this config type: " + type);
        }
        configService.saveConfig(config);
        return ResponseEntity.ok(Message.success("Update config success"));
    }

    @GetMapping(path={"/{type}"})
    @Operation(summary="Get the sender config", description="Get the sender config")
    public ResponseEntity<Message<Object>> getConfig(@Parameter(description="Config Type", example="email") @PathVariable(value="type") @NotNull String type) {
        GeneralConfigService configService = this.configServiceMap.get(type);
        if (configService == null) {
            throw new IllegalArgumentException("Not supported this config type: " + type);
        }
        return ResponseEntity.ok(Message.success(configService.getConfig()));
    }

    @PutMapping(path={"/template/{app}"})
    @Operation(summary="Update the app template config")
    public ResponseEntity<Message<Void>> updateTemplateAppConfig(@PathVariable(value="app") @NotNull String app, @RequestBody TemplateConfig.AppTemplate template) {
        GeneralConfigService configService = this.configServiceMap.get("template");
        if (configService == null || !(configService instanceof TemplateConfigServiceImpl)) {
            throw new IllegalArgumentException("Not supported this config type: template");
        }
        TemplateConfig config = (TemplateConfig)((TemplateConfigServiceImpl)configService).getConfig();
        if (config == null) {
            config = new TemplateConfig();
        }
        if (config.getApps() == null) {
            config.setApps(new HashMap<String, TemplateConfig.AppTemplate>(8));
        }
        config.getApps().put(app, template);
        configService.saveConfig(config);
        return ResponseEntity.ok(Message.success());
    }
}

