/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Locale;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.manager.pojo.dto.Hierarchy;
import org.apache.hertzbeat.manager.pojo.dto.MonitorDefineDto;
import org.apache.hertzbeat.manager.service.AppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Monitor Type Manage API")
@RestController
@RequestMapping(path={"/api/apps"}, produces={"application/json"})
public class AppController {
    private static final String[] RISKY_STR_ARR = new String[]{"ScriptEngineManager", "URLClassLoader", "!!", "ClassLoader", "AnnotationConfigApplicationContext", "FileSystemXmlApplicationContext", "GenericXmlApplicationContext", "GenericGroovyApplicationContext", "GroovyScriptEngine", "GroovyClassLoader", "GroovyShell", "ScriptEngine", "ScriptEngineFactory", "XmlWebApplicationContext", "ClassPathXmlApplicationContext", "MarshalOutputStream", "InflaterOutputStream", "FileOutputStream"};
    @Autowired
    private AppService appService;

    @GetMapping(path={"/{app}/params"})
    @Operation(summary="The structure of the input parameters required to specify the monitoring type according to the app query", description="The structure of the input parameters required to specify the monitoring type according to the app query")
    public ResponseEntity<Message<List<ParamDefine>>> queryAppParamDefines(@Parameter(description="en: Monitoring type name", example="api") @PathVariable(value="app") String app) {
        List<ParamDefine> paramDefines = this.appService.getAppParamDefines(app.toLowerCase());
        return ResponseEntity.ok(Message.success(paramDefines));
    }

    @GetMapping(path={"/{monitorId}/pushdefine"})
    @Operation(summary="The definition structure of the specified monitoring type according to the push query", description="The definition structure of the specified monitoring type according to the push query")
    public ResponseEntity<Message<Job>> queryPushDefine(@Parameter(description="en: Monitoring type name", example="api") @PathVariable(value="monitorId") Long monitorId) {
        Job define = this.appService.getPushDefine(monitorId);
        return ResponseEntity.ok(Message.success(define));
    }

    @GetMapping(path={"/{monitorId}/define/dynamic"})
    @Operation(summary="The definition structure of the specified monitoring type according to the push query", description="The definition structure of the specified monitoring type according to the push query")
    public ResponseEntity<Message<Job>> queryAutoGenerateDynamicAppDefine(@Parameter(description="Monitoring id", example="5435345") @PathVariable(value="monitorId") Long monitorId) {
        Job define = this.appService.getAutoGenerateDynamicDefine(monitorId);
        return ResponseEntity.ok(Message.success(define));
    }

    @GetMapping(path={"/{app}/define"})
    @Operation(summary="The definition structure of the specified monitoring type according to the app query", description="The definition structure of the specified monitoring type according to the app query")
    public ResponseEntity<Message<Job>> queryAppDefine(@Parameter(description="en: Monitoring type name", example="api") @PathVariable(value="app") String app) {
        Job define = this.appService.getAppDefine(app.toLowerCase());
        return ResponseEntity.ok(Message.success(define));
    }

    @GetMapping(path={"/{app}/define/yml"})
    @Operation(summary="The definition yml of the specified monitoring type according to the app query", description="The definition yml of the specified monitoring type according to the app query")
    public ResponseEntity<Message<String>> queryAppDefineYml(@Parameter(description="en: Monitoring type name", example="api") @PathVariable(value="app") String app) {
        String defineContent = this.appService.getMonitorDefineFileContent(app);
        return ResponseEntity.ok(Message.successWithData(defineContent));
    }

    @DeleteMapping(path={"/{app}/define/yml"})
    @Operation(summary="Delete monitor define yml", description="Delete the definition YML for the specified monitoring type according to the app")
    public ResponseEntity<Message<Void>> deleteAppDefineYml(@Parameter(description="en: Monitoring type name", example="api") @PathVariable(value="app") String app) {
        try {
            this.appService.deleteMonitorDefine(app);
        }
        catch (Exception e) {
            return ResponseEntity.ok(Message.fail((byte)15, e.getMessage()));
        }
        return ResponseEntity.ok(Message.success());
    }

    @PostMapping(path={"/define/yml"})
    @Operation(summary="Add new monitoring type define yml", description="Add new monitoring type define yml")
    public ResponseEntity<Message<Void>> newAppDefineYml(@Valid @RequestBody MonitorDefineDto defineDto) {
        try {
            for (String riskyToken : RISKY_STR_ARR) {
                if (!defineDto.getDefine().contains(riskyToken)) continue;
                return ResponseEntity.ok(Message.fail((byte)15, "can not has malicious remote script"));
            }
            this.appService.applyMonitorDefineYml(defineDto.getDefine(), false);
        }
        catch (Exception e) {
            return ResponseEntity.ok(Message.fail((byte)15, e.getMessage()));
        }
        return ResponseEntity.ok(Message.success());
    }

    @PutMapping(path={"/define/yml"})
    @Operation(summary="Update monitoring type define yml", description="Update monitoring type define yml")
    public ResponseEntity<Message<Void>> updateAppDefineYml(@Valid @RequestBody MonitorDefineDto defineDto) {
        try {
            for (String riskyToken : RISKY_STR_ARR) {
                if (!defineDto.getDefine().contains(riskyToken)) continue;
                return ResponseEntity.ok(Message.fail((byte)15, "can not has malicious remote script"));
            }
            this.appService.applyMonitorDefineYml(defineDto.getDefine(), true);
        }
        catch (Exception e) {
            return ResponseEntity.ok(Message.fail((byte)15, e.getMessage()));
        }
        return ResponseEntity.ok(Message.success());
    }

    @GetMapping(path={"/hierarchy"})
    @Operation(summary="Query all monitor metrics level, output in a hierarchical structure", description="Query all monitor metrics level, output in a hierarchical structure")
    public ResponseEntity<Message<List<Hierarchy>>> queryAppsHierarchy(@Parameter(description="en: language type", example="zh-CN") @RequestParam(name="lang", required=false) String lang) {
        if (lang == null || lang.isEmpty()) {
            lang = "zh-CN";
        }
        lang = lang.contains(Locale.ENGLISH.getLanguage()) ? "en-US" : (lang.contains(Locale.CHINESE.getLanguage()) ? "zh-CN" : "en-US");
        List<Hierarchy> appHierarchies = this.appService.getAllAppHierarchy(lang);
        return ResponseEntity.ok(Message.success(appHierarchies));
    }
}

