/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.usthe.sureness.util.JsonWebTokenUtil;
import jakarta.annotation.Resource;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.apache.hertzbeat.common.entity.manager.GeneralConfig;
import org.apache.hertzbeat.manager.dao.GeneralConfigDao;
import org.apache.hertzbeat.manager.pojo.dto.SystemConfig;
import org.apache.hertzbeat.manager.pojo.dto.SystemSecret;
import org.apache.hertzbeat.manager.pojo.dto.TemplateConfig;
import org.apache.hertzbeat.manager.service.AppService;
import org.apache.hertzbeat.manager.service.impl.SystemGeneralConfigServiceImpl;
import org.apache.hertzbeat.manager.service.impl.SystemSecretServiceImpl;
import org.apache.hertzbeat.manager.service.impl.TemplateConfigServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Order(value=-2147483646)
public class CommonCommandLineRunner
implements CommandLineRunner {
    private static final Integer LANG_REGION_LENGTH = 2;
    private static final String DEFAULT_JWT_SECRET = "CyaFv0bwq2Eik0jdrKUtsA6bx3sDJeFV643R LnfKefTjsIfJLBa2YkhEqEGtcHDTNe4CU6+9 8tVt4bisXQ13rbN0oxhUZR73M6EByXIO+SV5 dKhaX0csgOCTlCxq20yhmUea6H6JIpSE2Rwp";
    @Value(value="${sureness.jwt.secret:CyaFv0bwq2Eik0jdrKUtsA6bx3sDJeFV643R LnfKefTjsIfJLBa2YkhEqEGtcHDTNe4CU6+9 8tVt4bisXQ13rbN0oxhUZR73M6EByXIO+SV5 dKhaX0csgOCTlCxq20yhmUea6H6JIpSE2Rwp}")
    private String currentJwtSecret;
    @Resource
    private SystemGeneralConfigServiceImpl systemGeneralConfigService;
    @Resource
    private SystemSecretServiceImpl systemSecretService;
    @Resource
    private TemplateConfigServiceImpl templateConfigService;
    @Resource
    private AppService appService;
    @Resource
    protected GeneralConfigDao generalConfigDao;
    @Resource
    protected ObjectMapper objectMapper;

    @Override
    public void run(String ... args) throws Exception {
        SystemConfig systemConfig = (SystemConfig)this.systemGeneralConfigService.getConfig();
        if (systemConfig != null) {
            String[] arr;
            if (systemConfig.getTimeZoneId() != null) {
                TimeZone.setDefault(TimeZone.getTimeZone(systemConfig.getTimeZoneId()));
            }
            if (systemConfig.getLocale() != null && (arr = systemConfig.getLocale().split("_")).length == LANG_REGION_LENGTH) {
                String language = arr[0];
                String country = arr[1];
                Locale.setDefault(new Locale(language, country));
            }
        } else {
            systemConfig = SystemConfig.builder().timeZoneId(TimeZone.getDefault().getID()).locale(Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry()).build();
            String contentJson = this.objectMapper.writeValueAsString(systemConfig);
            GeneralConfig generalConfig2Save = GeneralConfig.builder().type(this.systemGeneralConfigService.type()).content(contentJson).build();
            this.generalConfigDao.save(generalConfig2Save);
        }
        TemplateConfig templateConfig = (TemplateConfig)this.templateConfigService.getConfig();
        this.appService.updateCustomTemplateConfig(templateConfig);
        if (DEFAULT_JWT_SECRET.equals(this.currentJwtSecret)) {
            SystemSecret systemSecret = (SystemSecret)this.systemSecretService.getConfig();
            if (systemSecret == null || !StringUtils.hasText(systemSecret.getJwtSecret())) {
                char[] chars = DEFAULT_JWT_SECRET.toCharArray();
                Random rand = new Random();
                for (int i = 0; i < chars.length; ++i) {
                    int index = rand.nextInt(chars.length);
                    char temp = chars[i];
                    chars[i] = chars[index];
                    chars[index] = temp;
                }
                this.currentJwtSecret = new String(chars);
                systemSecret = SystemSecret.builder().jwtSecret(this.currentJwtSecret).build();
                this.systemSecretService.saveConfig(systemSecret);
            } else {
                this.currentJwtSecret = systemSecret.getJwtSecret();
            }
        }
        JsonWebTokenUtil.setDefaultSecretKey(this.currentJwtSecret);
    }
}

