/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
final class TelegramBotAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(TelegramBotAlertNotifyHandlerImpl.class);

    TelegramBotAlertNotifyHandlerImpl() {
    }

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) throws AlertNoticeException {
        try {
            String url = String.format(this.alerterProperties.getTelegramWebhookUrl(), receiver.getTgBotToken());
            TelegramBotNotifyDTO notifyBody = TelegramBotNotifyDTO.builder().chatId(receiver.getTgUserId()).text(this.renderContent(noticeTemplate, alert)).disableWebPagePreview(true).build();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<TelegramBotNotifyDTO> telegramEntity = new HttpEntity<TelegramBotNotifyDTO>(notifyBody, headers);
            ResponseEntity<TelegramBotNotifyResponse> entity = this.restTemplate.postForEntity(url, telegramEntity, TelegramBotNotifyResponse.class, new Object[0]);
            if (entity.getStatusCode() == HttpStatus.OK && entity.getBody() != null) {
                TelegramBotNotifyResponse body = (TelegramBotNotifyResponse)entity.getBody();
                if (!body.ok) {
                    log.warn("Send Telegram Bot Failed: {}, error_code: {}", (Object)body.description, (Object)body.errorCode);
                    throw new AlertNoticeException(body.description);
                }
            } else {
                log.warn("Send Telegram Bot Failed {}", entity.getBody());
                throw new AlertNoticeException("Http StatusCode " + entity.getStatusCode());
            }
            log.debug("Send Telegram Bot Success");
        }
        catch (Exception e) {
            throw new AlertNoticeException("[Telegram Bot Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 7;
    }

    private static class TelegramBotNotifyDTO {
        @JsonProperty(value="chat_id")
        private String chatId;
        private String text;
        @JsonProperty(value="disable_web_page_preview")
        private Boolean disableWebPagePreview;

        TelegramBotNotifyDTO(String chatId, String text, Boolean disableWebPagePreview) {
            this.chatId = chatId;
            this.text = text;
            this.disableWebPagePreview = disableWebPagePreview;
        }

        public static TelegramBotNotifyDTOBuilder builder() {
            return new TelegramBotNotifyDTOBuilder();
        }

        public String getChatId() {
            return this.chatId;
        }

        public String getText() {
            return this.text;
        }

        public Boolean getDisableWebPagePreview() {
            return this.disableWebPagePreview;
        }

        @JsonProperty(value="chat_id")
        public void setChatId(String chatId) {
            this.chatId = chatId;
        }

        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="disable_web_page_preview")
        public void setDisableWebPagePreview(Boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TelegramBotNotifyDTO)) {
                return false;
            }
            TelegramBotNotifyDTO other = (TelegramBotNotifyDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$disableWebPagePreview = this.getDisableWebPagePreview();
            Boolean other$disableWebPagePreview = other.getDisableWebPagePreview();
            if (this$disableWebPagePreview == null ? other$disableWebPagePreview != null : !((Object)this$disableWebPagePreview).equals(other$disableWebPagePreview)) {
                return false;
            }
            String this$chatId = this.getChatId();
            String other$chatId = other.getChatId();
            if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TelegramBotNotifyDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $disableWebPagePreview = this.getDisableWebPagePreview();
            result = result * 59 + ($disableWebPagePreview == null ? 43 : ((Object)$disableWebPagePreview).hashCode());
            String $chatId = this.getChatId();
            result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "TelegramBotAlertNotifyHandlerImpl.TelegramBotNotifyDTO(chatId=" + this.getChatId() + ", text=" + this.getText() + ", disableWebPagePreview=" + this.getDisableWebPagePreview() + ")";
        }

        public static class TelegramBotNotifyDTOBuilder {
            private String chatId;
            private String text;
            private Boolean disableWebPagePreview;

            TelegramBotNotifyDTOBuilder() {
            }

            @JsonProperty(value="chat_id")
            public TelegramBotNotifyDTOBuilder chatId(String chatId) {
                this.chatId = chatId;
                return this;
            }

            public TelegramBotNotifyDTOBuilder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="disable_web_page_preview")
            public TelegramBotNotifyDTOBuilder disableWebPagePreview(Boolean disableWebPagePreview) {
                this.disableWebPagePreview = disableWebPagePreview;
                return this;
            }

            public TelegramBotNotifyDTO build() {
                return new TelegramBotNotifyDTO(this.chatId, this.text, this.disableWebPagePreview);
            }

            public String toString() {
                return "TelegramBotAlertNotifyHandlerImpl.TelegramBotNotifyDTO.TelegramBotNotifyDTOBuilder(chatId=" + this.chatId + ", text=" + this.text + ", disableWebPagePreview=" + this.disableWebPagePreview + ")";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class TelegramBotNotifyResponse {
        private boolean ok;
        @JsonProperty(value="error_code")
        private Integer errorCode;
        private String description;

        public boolean isOk() {
            return this.ok;
        }

        public Integer getErrorCode() {
            return this.errorCode;
        }

        public String getDescription() {
            return this.description;
        }

        public void setOk(boolean ok) {
            this.ok = ok;
        }

        @JsonProperty(value="error_code")
        public void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TelegramBotNotifyResponse)) {
                return false;
            }
            TelegramBotNotifyResponse other = (TelegramBotNotifyResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOk() != other.isOk()) {
                return false;
            }
            Integer this$errorCode = this.getErrorCode();
            Integer other$errorCode = other.getErrorCode();
            if (this$errorCode == null ? other$errorCode != null : !((Object)this$errorCode).equals(other$errorCode)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TelegramBotNotifyResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOk() ? 79 : 97);
            Integer $errorCode = this.getErrorCode();
            result = result * 59 + ($errorCode == null ? 43 : ((Object)$errorCode).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "TelegramBotAlertNotifyHandlerImpl.TelegramBotNotifyResponse(ok=" + this.isOk() + ", errorCode=" + this.getErrorCode() + ", description=" + this.getDescription() + ")";
        }
    }
}

