/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import java.util.ResourceBundle;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.common.util.ResourceBundleUtil;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.service.TencentSmsClient;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"common.sms.tencent.app-id"})
final class SmsAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(SmsAlertNotifyHandlerImpl.class);
    private final TencentSmsClient tencentSmsClient;
    private final ResourceBundle bundle = ResourceBundleUtil.getBundle("alerter");

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        try {
            String monitorName = null;
            if (alert.getTags() != null) {
                monitorName = alert.getTags().get("monitorName");
            }
            String[] params = new String[]{monitorName == null ? alert.getTarget() : monitorName, this.bundle.getString("alerter.priority." + alert.getPriority()), alert.getContent()};
            this.tencentSmsClient.sendMessage(params, new String[]{receiver.getPhone()});
        }
        catch (Exception e) {
            throw new AlertNoticeException("[Sms Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 0;
    }

    public SmsAlertNotifyHandlerImpl(TencentSmsClient tencentSmsClient) {
        this.tencentSmsClient = tencentSmsClient;
    }
}

