/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.mail.internet.MimeMessage;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.GeneralConfig;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.common.support.event.SystemConfigChangeEvent;
import org.apache.hertzbeat.common.util.ResourceBundleUtil;
import org.apache.hertzbeat.manager.component.alerter.AlertNotifyHandler;
import org.apache.hertzbeat.manager.dao.GeneralConfigDao;
import org.apache.hertzbeat.manager.pojo.dto.EmailNoticeSender;
import org.apache.hertzbeat.manager.service.MailService;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class EmailAlertNotifyHandlerImpl
implements AlertNotifyHandler {
    private static final Logger log = LoggerFactory.getLogger(EmailAlertNotifyHandlerImpl.class);
    private final JavaMailSender javaMailSender;
    private final MailService mailService;
    @Value(value="${spring.mail.host:smtp.demo.com}")
    private String host;
    @Value(value="${spring.mail.username:demo}")
    private String username;
    @Value(value="${spring.mail.password:demo}")
    private String password;
    @Value(value="${spring.mail.port:465}")
    private Integer port;
    @Value(value="${spring.mail.properties.mail.smtp.ssl.enable:true}")
    private boolean sslEnable = true;
    private final GeneralConfigDao generalConfigDao;
    private final ObjectMapper objectMapper;
    private static final String TYPE = "email";
    private ResourceBundle bundle = ResourceBundleUtil.getBundle("alerter");

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) throws AlertNoticeException {
        try {
            JavaMailSenderImpl sender = (JavaMailSenderImpl)this.javaMailSender;
            String fromUsername = this.username;
            try {
                String content;
                EmailNoticeSender emailNoticeSenderConfig;
                boolean useDatabase = false;
                GeneralConfig emailConfig = this.generalConfigDao.findByType(TYPE);
                if (emailConfig != null && emailConfig.getContent() != null && (emailNoticeSenderConfig = this.objectMapper.readValue(content = emailConfig.getContent(), EmailNoticeSender.class)).isEnable()) {
                    sender.setHost(emailNoticeSenderConfig.getEmailHost());
                    sender.setPort(emailNoticeSenderConfig.getEmailPort());
                    sender.setUsername(emailNoticeSenderConfig.getEmailUsername());
                    sender.setPassword(emailNoticeSenderConfig.getEmailPassword());
                    Properties props = sender.getJavaMailProperties();
                    props.put("mail.smtp.ssl.enable", (Object)emailNoticeSenderConfig.isEmailSsl());
                    fromUsername = emailNoticeSenderConfig.getEmailUsername();
                    useDatabase = true;
                }
                if (!useDatabase) {
                    sender.setHost(this.host);
                    sender.setPort(this.port);
                    sender.setUsername(this.username);
                    sender.setPassword(this.password);
                    Properties props = sender.getJavaMailProperties();
                    props.put("mail.smtp.ssl.enable", (Object)this.sslEnable);
                }
            }
            catch (Exception e) {
                log.error("Type not found {}", (Object)e.getMessage());
            }
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            messageHelper.setSubject(this.bundle.getString("alerter.notify.title"));
            messageHelper.setFrom(fromUsername);
            messageHelper.setTo(receiver.getEmail());
            messageHelper.setSentDate(new Date());
            String process = this.mailService.buildAlertHtmlTemplate(alert, noticeTemplate);
            messageHelper.setText(process, true);
            this.javaMailSender.send(mimeMessage);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[Email Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 1;
    }

    @EventListener(value={SystemConfigChangeEvent.class})
    public void onEvent(SystemConfigChangeEvent event) {
        log.info("{} receive system config change event: {}.", (Object)this.getClass().getName(), event.getSource());
        this.bundle = ResourceBundleUtil.getBundle("alerter");
    }

    public EmailAlertNotifyHandlerImpl(JavaMailSender javaMailSender, MailService mailService, GeneralConfigDao generalConfigDao, ObjectMapper objectMapper) {
        this.javaMailSender = javaMailSender;
        this.mailService = mailService;
        this.generalConfigDao = generalConfigDao;
        this.objectMapper = objectMapper;
    }
}

