/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
final class DiscordBotAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(DiscordBotAlertNotifyHandlerImpl.class);

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) throws AlertNoticeException {
        try {
            DiscordNotifyDTO notifyBody = DiscordNotifyDTO.builder().embeds(List.of(EmbedDTO.builder().title("[" + this.bundle.getString("alerter.notify.title") + "]").description(this.renderContent(noticeTemplate, alert)).build())).build();
            String url = String.format(this.alerterProperties.getDiscordWebhookUrl(), receiver.getDiscordChannelId());
            HttpHeaders headers = new HttpHeaders();
            headers.add("Authorization", "Bot " + receiver.getDiscordBotToken());
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<DiscordNotifyDTO> request = new HttpEntity<DiscordNotifyDTO>(notifyBody, headers);
            ResponseEntity<DiscordResponseDTO> entity = this.restTemplate.postForEntity(url, request, DiscordResponseDTO.class, new Object[0]);
            if (entity.getStatusCode() == HttpStatus.OK && entity.getBody() != null) {
                DiscordResponseDTO body = (DiscordResponseDTO)entity.getBody();
                if (body.id == null) {
                    log.warn("Send Discord Bot Failed: {}, error_code: {}", (Object)body.code, (Object)body.message);
                    throw new AlertNoticeException(body.message);
                }
            } else {
                log.warn("Send Discord Bot Failed {}", entity.getBody());
                throw new AlertNoticeException("Http StatusCode " + entity.getStatusCode());
            }
            log.debug("Send Discord Bot Success");
        }
        catch (Exception e) {
            throw new AlertNoticeException("[Discord Bot Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 9;
    }

    private static class DiscordNotifyDTO {
        private List<EmbedDTO> embeds;

        DiscordNotifyDTO(List<EmbedDTO> embeds) {
            this.embeds = embeds;
        }

        public static DiscordNotifyDTOBuilder builder() {
            return new DiscordNotifyDTOBuilder();
        }

        public List<EmbedDTO> getEmbeds() {
            return this.embeds;
        }

        public void setEmbeds(List<EmbedDTO> embeds) {
            this.embeds = embeds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiscordNotifyDTO)) {
                return false;
            }
            DiscordNotifyDTO other = (DiscordNotifyDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<EmbedDTO> this$embeds = this.getEmbeds();
            List<EmbedDTO> other$embeds = other.getEmbeds();
            return !(this$embeds == null ? other$embeds != null : !((Object)this$embeds).equals(other$embeds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DiscordNotifyDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<EmbedDTO> $embeds = this.getEmbeds();
            result = result * 59 + ($embeds == null ? 43 : ((Object)$embeds).hashCode());
            return result;
        }

        public String toString() {
            return "DiscordBotAlertNotifyHandlerImpl.DiscordNotifyDTO(embeds=" + this.getEmbeds() + ")";
        }

        public static class DiscordNotifyDTOBuilder {
            private List<EmbedDTO> embeds;

            DiscordNotifyDTOBuilder() {
            }

            public DiscordNotifyDTOBuilder embeds(List<EmbedDTO> embeds) {
                this.embeds = embeds;
                return this;
            }

            public DiscordNotifyDTO build() {
                return new DiscordNotifyDTO(this.embeds);
            }

            public String toString() {
                return "DiscordBotAlertNotifyHandlerImpl.DiscordNotifyDTO.DiscordNotifyDTOBuilder(embeds=" + this.embeds + ")";
            }
        }
    }

    private static class EmbedDTO {
        private String title;
        private String description;

        EmbedDTO(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public static EmbedDTOBuilder builder() {
            return new EmbedDTOBuilder();
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EmbedDTO)) {
                return false;
            }
            EmbedDTO other = (EmbedDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EmbedDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "DiscordBotAlertNotifyHandlerImpl.EmbedDTO(title=" + this.getTitle() + ", description=" + this.getDescription() + ")";
        }

        public static class EmbedDTOBuilder {
            private String title;
            private String description;

            EmbedDTOBuilder() {
            }

            public EmbedDTOBuilder title(String title) {
                this.title = title;
                return this;
            }

            public EmbedDTOBuilder description(String description) {
                this.description = description;
                return this;
            }

            public EmbedDTO build() {
                return new EmbedDTO(this.title, this.description);
            }

            public String toString() {
                return "DiscordBotAlertNotifyHandlerImpl.EmbedDTO.EmbedDTOBuilder(title=" + this.title + ", description=" + this.description + ")";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class DiscordResponseDTO {
        private String id;
        private Integer type;
        private String content;
        private String message;
        private Integer code;

        public String getId() {
            return this.id;
        }

        public Integer getType() {
            return this.type;
        }

        public String getContent() {
            return this.content;
        }

        public String getMessage() {
            return this.message;
        }

        public Integer getCode() {
            return this.code;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiscordResponseDTO)) {
                return false;
            }
            DiscordResponseDTO other = (DiscordResponseDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$type = this.getType();
            Integer other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DiscordResponseDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "DiscordBotAlertNotifyHandlerImpl.DiscordResponseDTO(id=" + this.getId() + ", type=" + this.getType() + ", content=" + this.getContent() + ", message=" + this.getMessage() + ", code=" + this.getCode() + ")";
        }
    }
}

