/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import java.util.Map;
import org.apache.hertzbeat.alert.service.AlertService;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.manager.component.alerter.AlertStoreHandler;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.apache.hertzbeat.manager.support.exception.IgnoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
final class DbAlertStoreHandlerImpl
implements AlertStoreHandler {
    private static final Logger log = LoggerFactory.getLogger(DbAlertStoreHandlerImpl.class);
    private final MonitorService monitorService;
    private final AlertService alertService;

    @Override
    public void store(Alert alert) {
        String monitorIdStr;
        Map<String, String> tags = alert.getTags();
        String string = monitorIdStr = tags != null ? tags.get("monitorId") : null;
        if (monitorIdStr != null) {
            long monitorId = Long.parseLong(monitorIdStr);
            Monitor monitor = this.monitorService.getMonitor(monitorId);
            if (monitor == null) {
                log.warn("Dispatch alarm the monitorId: {} not existed, ignored. target: {}.", (Object)monitorId, (Object)alert.getTarget());
                return;
            }
            if (!tags.containsKey("monitorName")) {
                tags.put("monitorName", monitor.getName());
            }
            if (!tags.containsKey("monitorHost")) {
                tags.put("monitorHost", monitor.getHost());
            }
            if (monitor.getStatus() == 0) {
                return;
            }
            if ("availability".equals(alert.getTarget())) {
                if (alert.getStatus() == 0 && monitor.getStatus() == 1) {
                    this.monitorService.updateMonitorStatus(monitor.getId(), (byte)2);
                } else if (alert.getStatus() == 2 && monitor.getStatus() == 2) {
                    this.monitorService.updateMonitorStatus(monitorId, (byte)1);
                }
            }
        } else {
            log.debug("store extern alert content: {}.", (Object)alert);
        }
        if (tags != null && tags.containsKey("ignore")) {
            throw new IgnoreException("Ignore this alarm.");
        }
        this.alertService.addAlert(alert);
    }

    public DbAlertStoreHandlerImpl(MonitorService monitorService, AlertService alertService) {
        this.monitorService = monitorService;
        this.alertService = alertService;
    }
}

