/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.hertzbeat.alert.AlerterWorkerPool;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeRule;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.manager.component.alerter.AlertNotifyHandler;
import org.apache.hertzbeat.manager.component.alerter.AlertStoreHandler;
import org.apache.hertzbeat.manager.service.NoticeConfigService;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.apache.hertzbeat.manager.support.exception.IgnoreException;
import org.apache.hertzbeat.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class DispatcherAlarm
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DispatcherAlarm.class);
    private static final int DISPATCH_THREADS = 3;
    private final AlerterWorkerPool workerPool;
    private final CommonDataQueue dataQueue;
    private final NoticeConfigService noticeConfigService;
    private final AlertStoreHandler alertStoreHandler;
    private final Map<Byte, AlertNotifyHandler> alertNotifyHandlerMap;

    public DispatcherAlarm(AlerterWorkerPool workerPool, CommonDataQueue dataQueue, NoticeConfigService noticeConfigService, AlertStoreHandler alertStoreHandler, List<AlertNotifyHandler> alertNotifyHandlerList) {
        this.workerPool = workerPool;
        this.dataQueue = dataQueue;
        this.noticeConfigService = noticeConfigService;
        this.alertStoreHandler = alertStoreHandler;
        this.alertNotifyHandlerMap = Maps.newHashMapWithExpectedSize(alertNotifyHandlerList.size());
        alertNotifyHandlerList.forEach(r -> this.alertNotifyHandlerMap.put(r.type(), (AlertNotifyHandler)r));
    }

    @Override
    public void afterPropertiesSet() {
        DispatchTask dispatchTask = new DispatchTask();
        for (int i = 0; i < 3; ++i) {
            this.workerPool.executeJob(dispatchTask);
        }
    }

    public boolean sendNoticeMsg(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        if (receiver == null || receiver.getType() == null) {
            log.warn("DispatcherAlarm-sendNoticeMsg params is empty alert:[{}], receiver:[{}]", (Object)alert, (Object)receiver);
            return false;
        }
        byte type = receiver.getType();
        if (this.alertNotifyHandlerMap.containsKey(type)) {
            this.alertNotifyHandlerMap.get(type).send(receiver, noticeTemplate, alert);
            return true;
        }
        return false;
    }

    private NoticeReceiver getOneReceiverById(Long id) {
        return this.noticeConfigService.getOneReceiverById(id);
    }

    private NoticeTemplate getOneTemplateById(Long id) {
        return this.noticeConfigService.getOneTemplateById(id);
    }

    private List<NoticeRule> matchNoticeRulesByAlert(Alert alert) {
        return this.noticeConfigService.getReceiverFilterRule(alert);
    }

    private class DispatchTask
    implements Runnable {
        private DispatchTask() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Alert alert = DispatcherAlarm.this.dataQueue.pollAlertsData();
                    if (alert == null) continue;
                    DispatcherAlarm.this.alertStoreHandler.store(alert);
                    this.sendNotify(alert);
                    ServiceLoader<Plugin> loader = ServiceLoader.load(Plugin.class, Plugin.class.getClassLoader());
                    for (Plugin plugin : loader) {
                        plugin.alert(alert);
                    }
                }
                catch (IgnoreException alert) {
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage());
                }
                catch (Exception exception) {
                    log.error(exception.getMessage(), exception);
                }
            }
        }

        private void sendNotify(Alert alert) {
            List<NoticeRule> noticeRules = DispatcherAlarm.this.matchNoticeRulesByAlert(alert);
            if (noticeRules != null) {
                for (NoticeRule rule : noticeRules) {
                    try {
                        List<Long> receiverIdList;
                        if (rule.getTemplateId() == null) {
                            receiverIdList = rule.getReceiverId();
                            for (Long receiverId : receiverIdList) {
                                DispatcherAlarm.this.sendNoticeMsg(DispatcherAlarm.this.getOneReceiverById(receiverId), null, alert);
                            }
                            continue;
                        }
                        receiverIdList = rule.getReceiverId();
                        for (Long receiverId : receiverIdList) {
                            DispatcherAlarm.this.sendNoticeMsg(DispatcherAlarm.this.getOneReceiverById(receiverId), DispatcherAlarm.this.getOneTemplateById(rule.getTemplateId()), alert);
                        }
                    }
                    catch (AlertNoticeException e) {
                        log.warn("DispatchTask sendNoticeMsg error, message: {}", (Object)e.getMessage());
                    }
                }
            }
        }
    }
}

